/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.traverse.generation;

import com.terraformersmc.terraform.biomeapi.OverworldBiomesExt;
import com.terraformersmc.terraform.config.BiomeConfig;
import com.terraformersmc.terraform.config.BiomeConfigNode;
import com.terraformersmc.traverse.Traverse;
import com.terraformersmc.traverse.biome.TraverseBiomes;
import net.fabricmc.fabric.api.biomes.v1.FabricBiomes;
import net.fabricmc.fabric.api.biomes.v1.OverworldBiomes;
import net.fabricmc.fabric.api.biomes.v1.OverworldClimate;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;

public class TraverseGeneration
extends TraverseBiomes {
    private static BiomeConfig config;

    public static void register() {
        config = Traverse.BIOME_CONFIG_HANDLER.getBiomeConfig();
        TraverseGeneration.addContinentalBiome(ARID_HIGHLANDS, OverworldClimate.DRY, 2.0);
        OverworldBiomes.addHillsBiome((class_1959)AUTUMNAL_WOODS, (class_1959)AUTUMNAL_WOODED_HILLS, (double)1.0);
        TraverseGeneration.addContinentalBiome(AUTUMNAL_WOODS, OverworldClimate.TEMPERATE, 1.0);
        TraverseGeneration.addContinentalBiome(AUTUMNAL_WOODS, OverworldClimate.COOL, 0.25);
        TraverseGeneration.addContinentalBiome(CLIFFS, OverworldClimate.TEMPERATE, 0.4);
        TraverseGeneration.addContinentalBiome(CLIFFS, OverworldClimate.COOL, 0.6);
        TraverseGeneration.addContinentalBiome(CLIFFS, OverworldClimate.SNOWY, 0.8);
        TraverseGeneration.addContinentalBiome(CONIFEROUS_FOREST, OverworldClimate.TEMPERATE, 0.8);
        TraverseGeneration.addContinentalBiome(CONIFEROUS_FOREST, OverworldClimate.COOL, 0.3);
        OverworldBiomes.addHillsBiome((class_1959)CONIFEROUS_FOREST, (class_1959)CONIFEROUS_WOODED_HILLS, (double)1.0);
        TraverseGeneration.addContinentalBiome(DESERT_SHRUBLAND, OverworldClimate.DRY, 0.8);
        TraverseGeneration.addContinentalBiome(HIGH_CONIFEROUS_FOREST, OverworldClimate.TEMPERATE, 0.2);
        TraverseGeneration.addContinentalBiome(HIGH_CONIFEROUS_FOREST, OverworldClimate.COOL, 0.075);
        TraverseGeneration.addBiomeVariant(class_1972.field_9471, LUSH_SWAMP, 0.2, new OverworldClimate[0]);
        TraverseGeneration.addContinentalBiome(MEADOW, OverworldClimate.TEMPERATE, 0.9);
        TraverseGeneration.addContinentalBiome(MEADOW, OverworldClimate.COOL, 0.9);
        TraverseGeneration.addBiomeVariant(class_1972.field_9451, MEADOW, 0.2, OverworldClimate.COOL, OverworldClimate.TEMPERATE);
        TraverseGeneration.addContinentalBiome(MINI_JUNGLE, OverworldClimate.TEMPERATE, 0.2);
        TraverseGeneration.addBiomeVariant(class_1972.field_9417, MINI_JUNGLE, 0.15, new OverworldClimate[0]);
        TraverseGeneration.addContinentalBiome(PLAINS_PLATEAU, OverworldClimate.DRY, 0.1);
        TraverseGeneration.addContinentalBiome(PLAINS_PLATEAU, OverworldClimate.COOL, 0.5);
        TraverseGeneration.addContinentalBiome(PLAINS_PLATEAU, OverworldClimate.TEMPERATE, 0.4);
        OverworldBiomes.setRiverBiome((class_1959)PLAINS_PLATEAU, null);
        OverworldBiomes.addEdgeBiome((class_1959)PLAINS_PLATEAU, (class_1959)ROCKY_EDGE, (double)1.0);
        TraverseGeneration.addContinentalBiome(ROLLING_HILLS, OverworldClimate.COOL, 0.7);
        OverworldBiomesExt.addCenterBiome((class_1959)CLIFFS, (class_1959)ROLLING_HILLS);
        TraverseGeneration.addContinentalBiome(SNOWY_CONIFEROUS_FOREST, OverworldClimate.SNOWY, 0.5);
        OverworldBiomes.addHillsBiome((class_1959)SNOWY_CONIFEROUS_FOREST, (class_1959)SNOWY_CONIFEROUS_WOODED_HILLS, (double)1.0);
        TraverseGeneration.addContinentalBiome(SNOWY_HIGH_CONIFEROUS_FOREST, OverworldClimate.SNOWY, 0.125);
        TraverseGeneration.addBiomeVariant(class_1972.field_9446, WOODED_ISLAND, 0.1, new OverworldClimate[0]);
        OverworldBiomes.addShoreBiome((class_1959)WOODED_ISLAND, (class_1959)WOODED_ISLAND, (double)1.0);
        OverworldBiomes.addHillsBiome((class_1959)PLAINS_PLATEAU, (class_1959)WOODED_PLATEAU, (double)1.0);
        TraverseGeneration.addContinentalBiome(WOODLANDS, OverworldClimate.DRY, 1.0);
        TraverseGeneration.addContinentalBiome(WOODLANDS, OverworldClimate.COOL, 1.0);
        TraverseGeneration.addContinentalBiome(WOODLANDS, OverworldClimate.TEMPERATE, 1.0);
        FabricBiomes.addSpawnBiome((class_1959)ARID_HIGHLANDS);
        FabricBiomes.addSpawnBiome((class_1959)AUTUMNAL_WOODS);
        FabricBiomes.addSpawnBiome((class_1959)CONIFEROUS_FOREST);
        FabricBiomes.addSpawnBiome((class_1959)DESERT_SHRUBLAND);
        FabricBiomes.addSpawnBiome((class_1959)MEADOW);
        FabricBiomes.addSpawnBiome((class_1959)ROLLING_HILLS);
        FabricBiomes.addSpawnBiome((class_1959)SNOWY_CONIFEROUS_FOREST);
        FabricBiomes.addSpawnBiome((class_1959)WOODLANDS);
        Traverse.BIOME_CONFIG_HANDLER.save();
    }

    private static void addBiomeVariant(class_1959 parent, class_1959 biome, double defaultChance, OverworldClimate ... climates) {
        boolean enable = !config.isFrozen();
        BiomeConfigNode.Variant variant = config.variant(class_2378.field_11153.method_10221((Object)biome).method_12832(), new BiomeConfigNode.Variant(enable, defaultChance));
        enable = variant.isEnabled();
        double chance = variant.getVariantChance();
        if (biome != null && enable && chance > 0.0) {
            OverworldBiomes.addBiomeVariant((class_1959)parent, (class_1959)biome, (double)chance, (OverworldClimate[])climates);
        }
    }

    private static void addContinentalBiome(class_1959 biome, OverworldClimate climate, double defaultWeight) {
        boolean enable = !config.isFrozen();
        BiomeConfigNode.Continental continental = config.continental(class_2378.field_11153.method_10221((Object)biome).method_12832(), new BiomeConfigNode.Continental(enable, defaultWeight));
        enable = continental.isEnabled();
        double weight = continental.getWeight();
        if (enable && weight > 0.0) {
            OverworldBiomes.addContinentalBiome((class_1959)biome, (OverworldClimate)climate, (double)weight);
        }
    }
}

