/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.traverse.biome;

import com.terraformersmc.terraform.biomebuilder.BiomeTemplate;
import com.terraformersmc.terraform.biomebuilder.DefaultFeature;
import com.terraformersmc.terraform.biomebuilder.TerraformBiomeBuilder;
import com.terraformersmc.terraform.biomebuilder.TerraformSlimeSpawnBiomes;
import com.terraformersmc.traverse.biome.AridHighlandsBiomes;
import com.terraformersmc.traverse.biome.AutumnalWoodsBiomes;
import com.terraformersmc.traverse.biome.CliffsBiomes;
import com.terraformersmc.traverse.biome.ConiferousForestBiomes;
import com.terraformersmc.traverse.biome.DesertShrublandBiomes;
import com.terraformersmc.traverse.biome.LushSwampBiomes;
import com.terraformersmc.traverse.biome.MeadowBiomes;
import com.terraformersmc.traverse.biome.MiniJungleBiomes;
import com.terraformersmc.traverse.biome.PlainsPlateauBiomes;
import com.terraformersmc.traverse.biome.RollingHillsBiomes;
import com.terraformersmc.traverse.biome.WoodedIslandBiomes;
import com.terraformersmc.traverse.biome.WoodlandsBiomes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3523;
import net.minecraft.class_3531;
import net.minecraft.class_3532;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5470;

public class TraverseBiomes {
    private static final Map<class_2960, class_1959> BIOMES = new HashMap<class_2960, class_1959>();
    static final BiomeTemplate BIOME_TEMPLATE = new BiomeTemplate(TerraformBiomeBuilder.create().configureSurfaceBuilder(class_3523.field_15701, (class_3531)class_3523.field_15677).addDefaultFeatures(new DefaultFeature[]{DefaultFeature.LAND_CARVERS, DefaultFeature.DEFAULT_UNDERGROUND_STRUCTURES, DefaultFeature.DUNGEONS, DefaultFeature.MINEABLES, DefaultFeature.ORES, DefaultFeature.DISKS, DefaultFeature.DEFAULT_MUSHROOMS, DefaultFeature.DEFAULT_VEGETATION, DefaultFeature.SPRINGS, DefaultFeature.FROZEN_TOP_LAYER}).addStructureFeature(class_5470.field_26302).addStructureFeature(class_5470.field_26293).precipitation(class_1959.class_1963.field_9382).effects(TraverseBiomes.createDefaultBiomeEffects()));
    protected static final class_5321<class_1959> ARID_HIGHLANDS = TraverseBiomes.add("arid_highlands", AridHighlandsBiomes.ARID_HIGHLANDS);
    protected static final class_5321<class_1959> AUTUMNAL_WOODS = TraverseBiomes.add("autumnal_woods", AutumnalWoodsBiomes.AUTUMNAL_WOODS);
    protected static final class_5321<class_1959> AUTUMNAL_WOODED_HILLS = TraverseBiomes.add("autumnal_wooded_hills", AutumnalWoodsBiomes.AUTUMNAL_WOODED_HILLS);
    protected static final class_5321<class_1959> CLIFFS = TraverseBiomes.add("cliffs", CliffsBiomes.CLIFFS);
    protected static final class_5321<class_1959> CONIFEROUS_FOREST = TraverseBiomes.add("coniferous_forest", ConiferousForestBiomes.CONIFEROUS_FOREST);
    protected static final class_5321<class_1959> CONIFEROUS_WOODED_HILLS = TraverseBiomes.add("coniferous_wooded_hills", ConiferousForestBiomes.CONIFEROUS_WOOODED_HILLS);
    protected static final class_5321<class_1959> DESERT_SHRUBLAND = TraverseBiomes.add("desert_shrubland", DesertShrublandBiomes.DESERT_SHRUBLAND);
    protected static final class_5321<class_1959> HIGH_CONIFEROUS_FOREST = TraverseBiomes.add("high_coniferous_forest", ConiferousForestBiomes.HIGH_CONIFEROUS_FOREST);
    protected static final class_5321<class_1959> LUSH_SWAMP = TraverseBiomes.add("lush_swamp", LushSwampBiomes.LUSH_SWAMP);
    protected static final class_5321<class_1959> MEADOW = TraverseBiomes.add("meadow", MeadowBiomes.MEADOW);
    protected static final class_5321<class_1959> MINI_JUNGLE = TraverseBiomes.add("mini_jungle", MiniJungleBiomes.MINI_JUNGLE);
    protected static final class_5321<class_1959> PLAINS_PLATEAU = TraverseBiomes.add("plains_plateau", PlainsPlateauBiomes.PLAINS_PLATEAU);
    protected static final class_5321<class_1959> ROCKY_EDGE = TraverseBiomes.add("rocky_edge", PlainsPlateauBiomes.ROCKY_EDGE);
    protected static final class_5321<class_1959> ROLLING_HILLS = TraverseBiomes.add("rolling_hills", RollingHillsBiomes.ROLLING_HILLS);
    protected static final class_5321<class_1959> SNOWY_CLIFFS = TraverseBiomes.add("snowy_cliffs", CliffsBiomes.SNOWY_CLIFFS);
    protected static final class_5321<class_1959> SNOWY_CONIFEROUS_FOREST = TraverseBiomes.add("snowy_coniferous_forest", ConiferousForestBiomes.SNOWY_CONIFEROUS_FOREST);
    protected static final class_5321<class_1959> SNOWY_CONIFEROUS_WOODED_HILLS = TraverseBiomes.add("snowy_coniferous_wooded_hills", ConiferousForestBiomes.SNOWY_CONIFEROUS_WOOODED_HILLS);
    protected static final class_5321<class_1959> SNOWY_HIGH_CONIFEROUS_FOREST = TraverseBiomes.add("snowy_high_coniferous_forest", ConiferousForestBiomes.SNOWY_HIGH_CONIFEROUS_FOREST);
    protected static final class_5321<class_1959> WOODED_ISLAND = TraverseBiomes.add("wooded_island", WoodedIslandBiomes.WOODED_ISLAND);
    protected static final class_5321<class_1959> WOODED_PLATEAU = TraverseBiomes.add("wooded_plateau", PlainsPlateauBiomes.WOODED_PLATEAU);
    protected static final class_5321<class_1959> WOODLANDS = TraverseBiomes.add("woodlands", WoodlandsBiomes.WOODLANDS);

    private static int getSkyColor(float temperature) {
        float f = temperature / 3.0f;
        f = class_3532.method_15363((float)f, (float)-1.0f, (float)1.0f);
        return class_3532.method_15369((float)(0.62222224f - f * 0.05f), (float)(0.5f + f * 0.1f), (float)1.0f);
    }

    public static class_4763.class_4764 createDefaultBiomeEffects() {
        return new class_4763.class_4764().method_24395(4159204).method_24397(329011).method_30820(TraverseBiomes.getSkyColor(0.2f)).method_24392(12638463);
    }

    static class_5321<class_1959> add(String name, class_1959 biome) {
        class_2960 id = new class_2960("traverse", name);
        BIOMES.put(id, biome);
        return class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)id);
    }

    public static void register() {
        for (class_2960 id : BIOMES.keySet()) {
            class_5458.method_30562((class_2378)class_5458.field_25933, (class_2960)id, (Object)BIOMES.get(id));
        }
        TerraformSlimeSpawnBiomes.addSlimeSpawnBiome(LUSH_SWAMP);
    }
}

