/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.github.io/license/

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

#define sun_illumination_mult 1.0   //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define moon_illumination_mult 1.0  //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.5 3.0 4.0 5.0]

const float planetRad   = 6371e3;       //earth rad
const float atmosDepth  = 110e3;
const float atmosRad    = planetRad+atmosDepth;       //atmosphere rad

const float ozoneAlt    = 38e3;

const float mie_g       = 0.78;

const vec3 rayleigh_coeff = vec3(5.147e-6, 1.1e-5, 3.31e-5);
const vec3 mie_coeff    = vec3(8.8e-6);    //19e-5 for rain
const vec3 ozone_coeff  = vec3(4.113e-7, 3.120e-7, 1.340e-8)*2.4;

//const vec3 planet_c     = vec3(0.0, -planetRad, 0.0);
const vec2 scale_h      = vec2(6.8e3, 2.1e3);
const vec2 scale_hRCP   = 1.0/scale_h;
const vec2 planet_scale = planetRad * scale_hRCP;

const vec3 sun_illum    = vec3(1.0, 0.95, 0.92) * 20.0 * sun_illumination_mult;
const vec3 moon_illum   = vec3(0.6, 0.75, 1.0) * 0.012 * moon_illumination_mult;

const mat2x3 scattering_mat   = mat2x3(rayleigh_coeff, mie_coeff);
const mat3x3 extinct_mat      = mat3x3(rayleigh_coeff, mie_coeff * 1.11, ozone_coeff);

//fog coefficients
const vec3 mist_coeff   = vec3(64e-6);

const mat3x3 fog_scatter_mat  = mat3x3(rayleigh_coeff, mie_coeff, mist_coeff);
const mat3x3 fog_extinct_mat  = mat3x3(rayleigh_coeff, mie_coeff * 1.11, mist_coeff);