/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.github.io/license/

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

uniform vec3 atmos_density;

float rsi(vec3 pos, vec3 dir, float r) {
    float b     = dot(pos, dir);
    float det   = pow2(b) - dot(pos, pos) + pow2(r);

    if (det<0.0) return -1.0;
        det     = sqrt(det);
    float t1    = -b - det;
    float t2    = -b + det;
    return (t1>=0.0) ? t1 : t2;
}
vec2 rsi2(vec3 pos, vec3 dir, float r) {
    float b     = dot(pos, dir);
    float det   = pow2(b) - dot(pos, pos) + pow2(r);

    if (det<0.0) return vec2(-1.0);
        det     = sqrt(det);

    vec2 ret = -b + vec2(-det, det);

    return ret;
}

float air_rsi(vec3 dir, vec3 pos) {
    vec2 p      = rsi2(pos, dir, planetRad);
    bool planet = p.y >= 0.0;
    vec2 adist = rsi2(pos, dir, atmosRad);
    vec2 pdist = rsi2(pos, dir, planetRad + -10e3);
    vec2 d  = vec2(0.0);
        d.x = planet && pdist.x < 0.0 ? pdist.y : max(adist.x, 0.0);
        d.y = planet && pdist.x > 0.0 ? pdist.x : adist.y;
    return abs(d.y - d.x);
}
float air_rsi(vec3 dir, vec3 pos, inout float sdx) {
    vec2 p      = rsi2(pos, dir, planetRad);
    bool planet = p.y >= 0.0;
    vec2 adist = rsi2(pos, dir, atmosRad);
    vec2 pdist = rsi2(pos, dir, planetRad + -10e3);
    vec2 d  = vec2(0.0);
        d.x = planet && pdist.x < 0.0 ? pdist.y : max(adist.x, 0.0);
        d.y = planet && pdist.x > 0.0 ? pdist.x : adist.y;

    sdx = -d.x;
    return abs(d.y - d.x);
}

vec3 get_rho(float dist) {  //air density
    vec2 rm     = expf(-dist * scale_hRCP + planet_scale);
        rm.y   *= 1.0 + wetness*(40.0);
        rm.x   *= 1.0 + wetness*0.5 + daytime.x * 0.5;

    float o     = expf(-max(0.0, (ozoneAlt-dist) - planetRad) * rcp(8.5e3))
                * expf(-max(0.0, (dist-ozoneAlt) - planetRad) * rcp(18.5e3));
    
    return vec3(rm, o) * atmos_density;
}

vec3 get_airmass(vec3 pos, vec3 dir, float dist, const int steps) {
    float rlength   = dist * rcp(float(steps));
    vec3 rstep      = dir * rlength;
        pos        += rstep * 0.5;

    vec3 rho        = vec3(0.0);

    for (int i = 0; i<steps; ++i, pos += rstep) {
        if (rho.y > 1e35) break;
        rho        += get_rho(length(pos));
    }
    return rho * rlength;
}
vec3 get_airmass(vec3 pos, vec3 dir, const int steps) {
    float dist  = rsi(pos, dir, atmosRad);

    return get_airmass(pos, dir, dist, steps);
}

vec3 air_transmittance(vec3 pos, vec3 dir, const int steps) {
    return max(expf(-extinct_mat*get_airmass(pos, dir, steps)), 0.0);
}
vec3 air_transmittance(vec3 pos, vec3 dir) {
    return air_transmittance(pos, dir, 4);
}

vec3 air_density(vec3 dir, vec3 pos, const int steps) {
    float dist  = air_rsi(pos, dir);
    vec3 rho    = get_rho(length(pos))*dist;
    vec3 rsum   = rho + get_airmass(pos, dir, dist, steps);

    return rsum;
}
vec3 air_density(vec3 dir, vec3 pos) {
    return air_density(dir, pos, 4);
}