/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.github.io/license/

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

#include "/lib/atmos/aconst.glsl"

#include "/lib/atmos/arho.glsl"

#ifdef atmos_fastpass
    #define ASKY_scatter_iterations 8
    #define ASKY_airmass_iterations 5
#else
    #define ASKY_scatter_iterations 10
    #define ASKY_airmass_iterations 6
#endif

#define ASKY_rayleigh_mult 1.3
#define ASKY_mie_mult 1.3
#define ASKY_multi_mult 0.72

void inscatter(vec3 pos, vec3 dir, mat2x3 lightdir, float dist, const int steps, inout vec3 rho, inout mat3x3 sun_scatter, inout mat3x3 moon_scatter) {
    float rlength = dist * rcp(float(steps));
    vec3 rstep  = dir * rlength;
        pos += rstep*0.25;

    vec3 transmittance = vec3(1.0);

    for (int i = 0; i<steps; ++i, pos += rstep) {
        vec3 r      = get_rho(length(pos));
        if (r.y > 1e35) break;
        vec3 srho   = r*rlength;
        vec3 od     = extinct_mat*srho;
        rho += srho;

        vec3 stept  = saturate(expf(-od));
        vec3 integ  = saturate((stept - 1.0) / -od);
        vec3 vscatter = transmittance * integ;

        vec3 airmass_sun = get_airmass(pos, lightdir[0], ASKY_airmass_iterations);
        vec3 atmost_sun = saturate(expf(-extinct_mat * airmass_sun));

        sun_scatter[0] += vscatter * srho.x * atmost_sun;    //rayleigh
        sun_scatter[1] += vscatter * srho.y * atmost_sun;    //mie
        sun_scatter[2] += vscatter * (scattering_mat*srho.xy) * atmost_sun;  //multiscatter

        if (daytime.w>0.0) {
            vec3 airmass_moon = get_airmass(pos, lightdir[1], ASKY_airmass_iterations);
            vec3 atmost_moon = saturate(expf(-extinct_mat * airmass_moon));

            moon_scatter[0] += vscatter * srho.x * atmost_moon;    //rayleigh
            moon_scatter[1] += vscatter * srho.y * atmost_moon;    //mie
            moon_scatter[2] += vscatter * (scattering_mat*srho.xy) * atmost_moon;  //multiscatter
        }

        transmittance *= stept;
    }
    moon_scatter *= sqrt(daytime.w);
}

vec2 phaseFunction(float cosTheta) { 
    return vec2(rayleigh_phase(cosTheta), hg_mie(cosTheta, mie_g));
}
float mie_backscatter(float cosTheta) {
    return hg_mie(cosTheta, -mie_g / 2.0);
}
vec2 phaseBackscatter(float cosTheta) {
    return vec2(rayleigh_phase(-cosTheta) / pi, mie_backscatter(cosTheta) / pi);
}

vec3 scatter(vec3 dir, mat2x3 lightdir, vec3 multi_int) {
    vec3 pos    = vec3(0.0, planetRad + eyeAltitude, 0.0);

    float dist  = air_rsi(pos, dir);

    vec3 rho    = vec3(0.0);

    mat3x3 sun_scatter = mat3x3(0.0);
    mat3x3 moon_scatter = mat3x3(0.0);

    inscatter(pos, dir, lightdir, dist, ASKY_scatter_iterations, rho, sun_scatter, moon_scatter);

    vec2 mu         = vec2(dot(dir, lightdir[0]), dot(dir, lightdir[1]));
    vec2 sun_phase  = phaseFunction(mu.x);
        sun_phase  += phaseBackscatter(mu.x);
    vec2 moon_phase = phaseFunction(mu.y);

    sun_scatter[0] *= ASKY_rayleigh_mult;
    sun_scatter[1] *= ASKY_mie_mult;
    sun_scatter[2] *= ASKY_multi_mult;

    vec3 scatter_sun    = sun_illum * (sun_scatter[0]*rayleigh_coeff*sun_phase.x + sun_scatter[1]*mie_coeff*sun_phase.y + sun_scatter[2]*multi_int);

    vec3 scatter_moon   = moon_illum * (moon_scatter[0]*rayleigh_coeff*moon_phase.x + moon_scatter[1]*mie_coeff*moon_phase.y + moon_scatter[2]*0.15);

    //transmittance = exp(-extinct_mat*rho);

    //if (isnan(scatter_sun.y)) return vec3(10.0);

    scatter_sun     = max(scatter_sun, 0.0);
    scatter_moon    = max(scatter_moon, 0.0);

    //if (isnan3(scatter_sun) || isinf3(scatter_sun) || isnan3(scatter_moon) || isinf3(scatter_moon)) return vec3(0.0, 0.0, 10.0);

    return (scatter_sun + scatter_moon) * 1.85;
}