/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.github.io/license/

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

#define sunlight_luma 1.0
#define skylight_luma 1.0
#define blocklight_luma 1.0     //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

uniform float eyeAltitude;
uniform float wetness;

uniform vec2 viewSize;

uniform vec3 sunvec;

uniform vec4 daytime;

uniform sampler2D gaux2;

flat out float light_flip;

#ifdef cloudpass
flat out vec3 cloudSunlight;
#endif

flat out mat4x3 light_color;

#ifdef skypass
flat out mat3x3 sky_color;
#endif

#include "/lib/atmos/aconst.glsl"

#include "/lib/atmos/arho.glsl"

#include "/lib/atmos/project.glsl"

void make_colors() {
    /*
    vec3 sunlightSunrise;
        sunlightSunrise.r   = 1.00;
        sunlightSunrise.g   = 0.15;
        sunlightSunrise.b   = 0.0;
        sunlightSunrise    *= 0.5;

    vec3 sunlightNoon;
        sunlightNoon.r      = 1.00;
        sunlightNoon.g      = 0.96;
        sunlightNoon.b      = 0.92;
        sunlightNoon       *= 1.0;

    vec3 sunlightSunset;
        sunlightSunset.r    = 1.00;
        sunlightSunset.g    = 0.13;
        sunlightSunset.b    = 0.0;
        sunlightSunset     *= 0.5;

    vec3 sunlightNight;
        sunlightNight.r     = 1.00;
        sunlightNight.g     = 0.1;
        sunlightNight.b     = 0.0;
        sunlightNight      *= 0.4;

    light_color[0]  = sunlightSunrise*daytime.x + sunlightNoon*daytime.y + sunlightSunset*daytime.z + sunlightNight*daytime.w;
    light_color[0] *= sunlight_luma * 10.0;*/
    /*
    vec3 skylightSunrise;
        skylightSunrise.r   = 0.2;
        skylightSunrise.g   = 0.4;
        skylightSunrise.b   = 1.00;
        skylightSunrise    *= 0.33;

    vec3 skylightNoon;
        skylightNoon.r      = 0.25;
        skylightNoon.g      = 0.5;
        skylightNoon.b      = 1.0;
        skylightNoon       *= 1.0;

    vec3 skylightSunset;
        skylightSunset.r    = 0.25;
        skylightSunset.g    = 0.3;
        skylightSunset.b    = 1.0;
        skylightSunset     *= 0.15;

    vec3 skylightNight;
        skylightNight.r     = 0.2;
        skylightNight.g     = 0.4;
        skylightNight.b     = 1.0;
        skylightNight      *= 0.01;

    light_color[1]  = skylightSunrise*daytime.x + skylightNoon*daytime.y + skylightSunset*daytime.z + skylightNight*daytime.w;
    light_color[1] *= skylight_luma*0.66;*/

    light_color[0]  = sun_illum * air_transmittance(vec3(0.0, planetRad, 0.0), sunvec, 6);

    #ifdef cloudpass
    cloudSunlight   = sun_illum * air_transmittance(vec3(0.0, planetRad + 250.0, 0.0), sunvec, 5) * (1.0-wetness*0.5);
    #endif

    light_color[1]  = texture(gaux2, projectSky(vec3(0.0, 1.0, 0.0))).rgb * pi;

    light_color[2]  = vec3(blocklightR, blocklightG, blocklightB)*blocklight_luma*2.5;

    light_color[3]  = vec3(0.32, 0.7, 1.0)*0.008;

    float lf    = dot(sunvec, vec3(0.0, 1.0, 0.0))*0.5+0.5;
        lf      = lin_step(lf, 0.48, 0.499)*(1.0-lin_step(lf, 0.501, 0.52));

    light_flip  = saturate(1.0-lf);

    /*
    #ifdef skypass
        vec3 skySunrise;
            skySunrise.r = 0.19;
            skySunrise.g = 0.4;
            skySunrise.b = 1.00;
            skySunrise  *= 0.15;
            skySunrise = color_saturation(skySunrise, 0.72);

        vec3 skyNoon;
            skyNoon.r   = 0.17;
            skyNoon.g   = 0.36;
            skyNoon.b   = 1.00;
            skyNoon    *= 1.3;

        vec3 skySunset;
            skySunset.r = 0.19;
            skySunset.g = 0.4;
            skySunset.b = 1.0;
            skySunset  *= 0.12;
            skySunset   = color_saturation(skySunset, 0.72);

        vec3 skyNight;
            skyNight.r  = 0.14;
            skyNight.g  = 0.58;
            skyNight.b  = 1.00;
            skyNight   *= 0.0003;

        sky_color[0]    = skySunrise*daytime.x + skyNoon*daytime.y + skySunset*daytime.z + skyNight*daytime.w;

        vec3 horSunrise;
            horSunrise.r = 1.00;
            horSunrise.g = 0.17;
            horSunrise.b = 0.00;
            horSunrise  *= 1.0;

        vec3 horNoon;
            horNoon.r   = 0.72;
            horNoon.g   = 0.89;
            horNoon.b   = 1.00;
            horNoon    *= 1.25;

        vec3 horSunset;
            horSunset.r = 1.00;
            horSunset.g = 0.17;
            horSunset.b = 0.0;
            horSunset  *= 1.0;

        vec3 horNight;
            horNight.r  = 0.3;
            horNight.g  = 0.7;
            horNight.b  = 1.00;
            horNight   *= 0.0015;

        sky_color[1]    = horSunrise*daytime.x + horNoon*daytime.y + horSunset*daytime.z + horNight*daytime.w;

        vec3 sgSunrise;
            sgSunrise.r = 1.00;
            sgSunrise.g = 0.22;
            sgSunrise.b = 0.02;
            sgSunrise  *= 0.9;

        vec3 sgNoon;
            sgNoon.r   = 1.0;
            sgNoon.g   = 1.0;
            sgNoon.b   = 1.0;
            sgNoon    *= 1.0;

        vec3 sgSunset;
            sgSunset.r = 1.00;
            sgSunset.g = 0.22;
            sgSunset.b = 0.0;
            sgSunset  *= 0.8;

        vec3 sgNight;
            sgNight.r  = 1.0;
            sgNight.g  = 0.22;
            sgNight.b  = 0.0;
            sgNight   *= 0.5;

        sky_color[2]    = sgSunrise*daytime.x + sgNoon*daytime.y + sgSunset*daytime.z + sgNight*daytime.w;

        sky_color *= 4.0;
    #endif*/
}