/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.github.io/license/

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

float water_noise(vec2 pos) {
    return pow2(1.0-textureBicubic(noisetex, pos/256.0).x);
}

float water_height(vec3 pos) {
    float time  = frameTimeCounter*3.0;
    if (mat_id == 103) time = 0.0;

    vec2 p      = pos.xz+pos.y*rcp(pi);
        p      *= 0.45;

    vec2 dir    = vec2(0.4, 0.8);

    float wave  = 0.0;

    float amp   = 0.5;
    float steep = 0.15;
    float wlength = 2.0;
    float a     = tau/2.618;

    //p     = rotate_coord(p, a*0.3);
    p    *= 1.5;

    p.x *= 0.7;

    for (int i = 0; i<water_normal_octaves; ++i) {
        float n = water_noise(p+wave + dir*time)*amp;
        wave   += n;
        time   *= 1.2;
        amp    *= 0.5;
        //p     += n;
        p    *= 2.0;
        dir     = rotate_coord(dir.xy, a);
        p     = rotate_coord(p, a*0.1);
    }

    return wave*0.6;
}