/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.github.io/license/

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

#include "/lib/common.glsl"
#include "/lib/util/srgb.glsl"

#define INFO 0  //[0]

in vec2 coord;

uniform sampler2D colortex0;
uniform sampler2D colortex3;
uniform sampler2D colortex4;

uniform sampler2D noisetex;

uniform int frameCounter;

uniform float frameTimeCounter;
uniform float nightVision;

uniform vec2 pixelSize;
uniform vec2 viewSize;

vec3 purkinje(vec3 hdr) {
    const vec3 reseponse = vec3(0.15, 0.50, 0.35);

    vec3 desat_color    = vec3(0.2, 0.7, 1.0);
        desat_color     = mix(desat_color, vec3(0.5, 0.9, 1.0), nightVision);

    float desat = dot(hdr, reseponse) * (1.0 + nightVision);
    hdr         = mix(hdr, vec3(desat)*desat_color, (1.0-sstep(desat, 0.0, 0.005 * (1.0 + nightVision))));

    vec2 noisecoord = coord*viewSize;
    float anim  = frameTimeCounter*8*256;

    vec3 noise  = vec3(0.0);
        noise.r = texture(noisetex, floor(noisecoord+anim*1.8)*rcp(256.0)).x;
        noise.g = texture(noisetex, floor(noisecoord+vec2(-anim, anim)*1.2)*rcp(256.0)).x;
        noise.b = texture(noisetex, floor(noisecoord+vec2(anim, -anim)*1.4)*rcp(256.0)).x;

        hdr    += noise * sqrt(1.0-sstep(desat, 0.00, 0.005)) * 0.0007;

    return hdr;
}

vec3 tonemap_reinhard(vec3 hdr) {
    float luma      = get_luma(hdr);

        hdr        *= 0.66;

        hdr         = pow(hdr, vec3(0.96));

    float coeff     = 0.25;

    vec3 col        = hdr/(hdr + coeff);
        col         = mix(hdr/(luma + 0.95), col, col) * 1.1;

    return to_srgb(saturate(col));
}

vec3 vignette(vec3 color) {
    float fade      = length(coord*2.0-1.0);
        fade        = lin_step(abs(fade), 0.3, 1.8);
        fade        = 1.0-pow3(fade)*0.75;

    return color * fade;
}

/* ------ color grading utilities ------ */

vec3 rgb_luma(vec3 x) {
    x.r *= colorlum_r;
    x.g *= colorlum_g;
    x.b *= colorlum_b;

    return x;
}

/* --- post tonemap color grading --- */
vec3 gammacurve(vec3 x) {
    return pow(x, vec3(gamma_curve + 0.02));
}

vec3 vibrance_saturation(vec3 color) {
    float lum   = dot(color, lumacoeff_rec709);
    float mn    = min(min(color.r, color.g), color.b);
    float mx    = max(max(color.r, color.g), color.b);
    float sat   = (1.0 - (mx-mn)) * (1.0-mx) * lum * 5.0;
    vec3 light  = vec3((mn + mx) / 2.0);

    color   = mix(color, mix(light, color, vibrance_int), sat);

    color   = mix(color, light, (1.0-light) * (1.0-vibrance_int) / 2.0 * abs(vibrance_int));

    color   = mix(vec3(lum), color, saturation_int);

    return saturate(color);
}

void main() {
    vec3 scene_hdr  = stex(colortex0).rgb;

    #ifdef bloom_enabled
    vec2 cres       = max(viewSize, vec2(1920.0, 1080.0));

    float bloom_int = 0.04 + max(stex(colortex4).a, 1.0)*0.002;

    #if dim == -1
        bloom_int  *= 2.0;
    #elif dim == 1
        bloom_int  *= 1.5;
    #endif

        scene_hdr  += texture(colortex3, coord/cres*vec2(1920.0, 1080.0)*0.5).rgb*bloom_int;  //apply bloom
    #endif

    #ifndef dim
        scene_hdr   = purkinje(scene_hdr);
    #endif

    #ifdef do_colorgrading
        scene_hdr   = rgb_luma(scene_hdr);
    #endif

    #ifdef manual_exposure_enabled
        scene_hdr  *= rcp(manual_exposure);
    #else
        scene_hdr  *= stex(colortex4).a;
    #endif

    vec3 scene_sdr  = tonemap_reinhard(scene_hdr);
        scene_sdr   = vignette(scene_sdr);

    #ifdef do_colorgrading
        scene_sdr   = vibrance_saturation(scene_sdr);
    #endif

        scene_sdr   = gammacurve(scene_sdr);

    /*DRAWBUFFERS:0*/
    gl_FragData[0]  = make_drawbuffer(scene_sdr);
}