/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.github.io/license/

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/


/* ------ atmosphere ------ */
#define sky_hq_lookup

    /* ------ cloud settings ------ */
    #define vcloud_enabled
    #define vcloud_samples 30   //[15 20 25 30 35 40 45 50]
    #define vcloud_alt 185.0    //[175.0 180.0 185.0 190.0 195.0 200.0 210.0 220.0 230.0 240.0 250.0]
    #define vcloud_depth 275.0  //[250.0 275.0 300.0 325.0 350.0 400.0]
    #define vcloud_clip 8000.0

    #define pcloud_enabled
    #define pcloud_alt  1000.0 //[700.0 800.0 900.0 1000.0 1200.0 1400.0 1600.0 1800.0]
    #define pcloud_depth 450.0 //[300.0 350.0 400.0 450.0 500.0 550.0 600.0 650.0 700.0]
    #define pcloud_clip 15000.0

    /* ------ fog settings ------ */
    #define vfog_enabled
    #define vfog_mist_enabled
    #define vfog_quality 1.0    //[0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0]
    #define vfog_density 1.0    //[0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0 2.5 3.0 3.5 4.0 5.0 6.0 7.0 8.0 10.0 12.0 14.0]
    //#define vfog_hq_mist

    #ifdef vfog_enabled
        #define vfog_translucents
    #endif

    #define vfog_bilateral

    #define vwater_enabled
    #define vwater_quality 1.0  //[0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0]
    #define vwater_bilateral
    //#define vwater_caustic
    #define vwater_density 1.0    //[0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0 2.5 3.0 3.5 4.0 5.0 6.0 7.0 8.0 10.0 12.0 14.0]

/* ------ lighting settings ------ */
//#define shadowfilter_hq
#define minlight_luma 0.1   //[0.1 0.2 0.3 0.4 0.5 0.75 1.0 1.25 1.5 1.75 2.0 2.5 3.0 3.5 4.0 5.0 6.0 7.0 8.0 9.0 10.0]

    /* ------ effects settings ------ */
    #define ambientOcclusion_enabled

#define blocklightR 1.0     //[0.0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2 0.21 0.22 0.23 0.24 0.25 0.26 0.27 0.28 0.29 0.3 0.31 0.32 0.33 0.34 0.35 0.36 0.37 0.38 0.39 0.4 0.41 0.42 0.43 0.44 0.45 0.46 0.47 0.48 0.49 0.5 0.51 0.52 0.53 0.54 0.55 0.56 0.57 0.58 0.59 0.6 0.61 0.62 0.63 0.64 0.65 0.66 0.67 0.68 0.69 0.7 0.71 0.72 0.73 0.74 0.75 0.76 0.77 0.78 0.79 0.8 0.81 0.82 0.83 0.84 0.85 0.86 0.87 0.88 0.89 0.9 0.91 0.92 0.93 0.94 0.95 0.96 0.97 0.98 0.99 1.0]
#define blocklightG 0.18    //[0.0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2 0.21 0.22 0.23 0.24 0.25 0.26 0.27 0.28 0.29 0.3 0.31 0.32 0.33 0.34 0.35 0.36 0.37 0.38 0.39 0.4 0.41 0.42 0.43 0.44 0.45 0.46 0.47 0.48 0.49 0.5 0.51 0.52 0.53 0.54 0.55 0.56 0.57 0.58 0.59 0.6 0.61 0.62 0.63 0.64 0.65 0.66 0.67 0.68 0.69 0.7 0.71 0.72 0.73 0.74 0.75 0.76 0.77 0.78 0.79 0.8 0.81 0.82 0.83 0.84 0.85 0.86 0.87 0.88 0.89 0.9 0.91 0.92 0.93 0.94 0.95 0.96 0.97 0.98 0.99 1.0]
#define blocklightB 0.03    //[0.0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2 0.21 0.22 0.23 0.24 0.25 0.26 0.27 0.28 0.29 0.3 0.31 0.32 0.33 0.34 0.35 0.36 0.37 0.38 0.39 0.4 0.41 0.42 0.43 0.44 0.45 0.46 0.47 0.48 0.49 0.5 0.51 0.52 0.53 0.54 0.55 0.56 0.57 0.58 0.59 0.6 0.61 0.62 0.63 0.64 0.65 0.66 0.67 0.68 0.69 0.7 0.71 0.72 0.73 0.74 0.75 0.76 0.77 0.78 0.79 0.8 0.81 0.82 0.83 0.84 0.85 0.86 0.87 0.88 0.89 0.9 0.91 0.92 0.93 0.94 0.95 0.96 0.97 0.98 0.99 1.0]



/* ------ world settings ------ */

    //#define normalmapEnabled
    #define normalmapFormat 0   //[0 1]

    /* ------ reflection settings ------ */
    #define reflections_enabled

    #ifdef reflections_enabled
        #define ssr_enabled
        #define cloud_reflections_enabled
    #endif

    /* ------ water settings ------ */
    #define water_normal_hq
    #define water_normal_octaves 4  //[2 3 4 5 6 7 8]
    #define water_parallax_enabled
    #define water_parallax_steps 6  //[3 4 5 6 7 8 9]
    #define water_caustic

    #define custom_water
    #define custom_ice

#define wind_effects_enabled
#define wind_intensity 1.0  //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]


/* ------ post processing settings ------ */
#define taa_enabled
#define image_sharpen

    /* ------ exposure settings ------ */
    #define exposure_minlum 1.0     //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.2 1.4 1.6 1.8 2.0 2.2. 2.4 2.6 2.8 3.0 3.5 4.0 5.0 6.0 8.0 10.0 15.0 20.0]
    #define exposure_speed 1.0      //[0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0 2.5 3.0 4.0]
    //#define manual_exposure_enabled
    #define manual_exposure 5.0     //[0.1 0.3 0.5 1.0 1.5 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 12.0 14.0 16.0 18.0 20.0 25.0 30.0 40.0 50.0]

    /* ------ camera settings ------ */
    #define bloom_enabled
    #define bloom_intensity 1.0     //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

    #define motionblur_enabled
    #define motionblur_samples 8    //[4 6 8 10 12 14 16]
    #define motionblur_size 1.0     //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

    /* ------ color grading settings ------ */
    //#define do_colorgrading

    #define vibrance_int 1.0    //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
    #define saturation_int 1.0  //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
    #define gamma_curve 1.0     //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
    #define brightness_int 0.0  //[-0.5 -0.4 -0.3 -0.2 -0.1 0.0 0.1 0.2 0.3 0.4 0.5]
    #define constrast_int 1.0   //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

    #define colorlum_r 1.0      //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
    #define colorlum_g 1.0      //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
    #define colorlum_b 1.0      //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]


/* ------ internals ------ */
#define DEBUG_VIEW 0    //[0 1 2 3 4] 0-off, 1-whiteworld, 2-ao
#define SKY_RENDER_LOD 2
#define CLOUD_RENDER_LOD 5.0
#define SKYREF_LOD 3.0
#define cloud_atmos_density 1.85e-5