#version 400 compatibility

/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.github.io/license/

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

#include "/lib/common.glsl"

in vec2 coord;

uniform sampler2D colortex5;
uniform sampler2D colortex6;

uniform sampler2D depthtex0;
uniform sampler2D depthtex1;

uniform float far, near;

uniform vec2 pixelSize, viewSize;

float depth_lin(float depth) {
    return (2.0*near) / (far+near-depth * (far-near));
}

const float kernelW_3x3[9]  = float[9](
    0.0625, 0.125, 0.0625,
    0.125,  0.250, 0.125,
    0.0625, 0.125, 0.0625
);

const ivec2 kernelO_3x3[9]  = ivec2[9](
    ivec2(-1, -1), ivec2(0, -1), ivec2(1, -1),
    ivec2(-1, 0),  ivec2(0, 0),  ivec2(1, 0),
    ivec2(-1, 1),  ivec2(0, 1),  ivec2(1, 1)
);

mat2x4 filter_3x3_double(sampler2D tex1, sampler2D tex2, sampler2D depth, vec2 coord, const int size, const float lod, const vec2 offset) {
    ivec2 d_pos = ivec2((coord + offset) * viewSize * lod);
    ivec2 c_pos  = ivec2(coord * viewSize);

    float center_depth  = texelFetch(depth, d_pos, 0).x;
        center_depth    = depth_lin(center_depth) * far;

    mat2x4 sumcol     = mat2x4(0.0);
    float sumweight = 0.0;
    
    const float depth_thresh    = 0.5;

    for (int i = 0; i<9; i++) {
        ivec2 delta_pos  = kernelO_3x3[i] * size;

        float blur  = kernelW_3x3[i];

        ivec2 depth_pos  = d_pos + ivec2(delta_pos * lod);
        float curr_depth = depth_lin(texelFetch(depth, depth_pos, 0).x) * far;
        float depth_weight = expf(-max(distance(curr_depth, center_depth) - 0.075, 0.0) * 0.6);

        ivec2 curr_pos   = c_pos + delta_pos;

        mat2x4 curr_col;
            curr_col[0]  = texelFetch(tex1, curr_pos, 0);
            curr_col[1]  = texelFetch(tex2, curr_pos, 0);

        float weight    = depth_weight;

        sumcol     += curr_col * weight;
        sumweight  += 1.0 * weight;
    }

    sumcol /= max(sumweight, 1e-16);

    return sumcol;
}

void main() {
    vec4 return5    = stex(colortex5);
    vec4 return6    = stex(colortex6);

    #ifdef vfog_enabled
    vec2 fog0_coord = (coord - vec2(0.5, 0.0)) * 2.0;
    if (fog0_coord == clamp(fog0_coord, -pixelSize*2, 1.0 + pixelSize*2)) {
        mat2x4  data    = filter_3x3_double(colortex5, colortex6, depthtex1, coord, 1, 2.0, vec2(-0.5, 0.0));

        return5     = data[0];
        return6     = data[1];
    }
    #endif

    #if (defined vwater_enabled || defined vfog_translucents)
    vec2 fog1_coord = (coord - vec2(0.0, 0.5)) * 2.02;
    if (fog1_coord == clamp(fog1_coord, -pixelSize*2, 1.0 + pixelSize*2)) {
        mat2x4  data    = filter_3x3_double(colortex5, colortex6, depthtex0, coord, 1, 2.02, vec2(0.0, -0.5));

        return5     = data[0];
        return6     = data[1];
    }
    #endif

    /*DRAWBUFFERS:56*/
    gl_FragData[0]  = clamp_drawbuffer(return5);
    gl_FragData[1]  = clamp_drawbuffer(return6); 
}