#version 400 compatibility

/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.github.io/license/

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

#include "/lib/common.glsl"

/*
const int colortex0Format   = RGBA16F;
const int colortex1Format   = RGBA16;
const int colortex2Format   = RG16;
const int colortex3Format   = RGBA16F;
const int colortex4Format   = RGBA16F;
const int colortex5Format   = RGB16F;
const int colortex6Format   = RGBA16F;

const vec4 colortex0ClearColor = vec4(0.0, 0.0, 0.0, 1.0);
const vec4 colortex3ClearColor = vec4(0.0, 0.0, 0.0, 0.0);

c0  - 4x16 scene color (full)
c1  - 1x16 encoded normals, 1x16 lightmaps, 2x16 specular texture (gbuffer -> composite2)
c2  - 1x16 matID, 1x16 translucency albedo hue  (gbuffer -> composite2)
c3  - 4x16 translucencies  (water -> composite0), bloom (composite7 -> final)
c4  - temporals (full)
c5  - 3x16 sky
c6  - 4x16 clouds (composite0 -> composite1)
*/

in vec2 coord;

flat in vec3 atmos_multiscatter;
flat in vec3 atmos_upcol;

flat in mat4x3 light_color;

uniform vec2 viewSize;
uniform vec2 pixelSize;

uniform sampler2D colortex0;
uniform sampler2D depthtex1;

uniform sampler2D noisetex;
uniform sampler3D depthtex2;

uniform int frameCounter;
uniform int worldTime;

uniform vec4 daytime;
uniform float eyeAltitude;
uniform float frameTimeCounter;
uniform float cloud_bsfade;
uniform float wetness;

uniform vec3 upvec, upvecView;
uniform vec3 sunvec, sunvecView;
uniform vec3 moonvec, moonvecView;
uniform vec3 lightvec;
uniform vec3 cloud_lvec, cloud_lvecView;

uniform vec3 cameraPosition;

uniform mat4 gbufferModelView, gbufferModelViewInverse;
uniform mat4 gbufferProjection, gbufferProjectionInverse;

vec3 screen_viewspace(vec3 screenpos, mat4 projInv) {
    screenpos   = screenpos*2.0-1.0;

    vec3 viewpos    = vec3(vec2(projInv[0].x, projInv[1].y)*screenpos.xy + projInv[3].xy, projInv[3].z);
        viewpos    /= projInv[2].w*screenpos.z + projInv[3].w;
    
    return viewpos;
}

vec3 screen_viewspace(vec3 screenpos) {
    return screen_viewspace(screenpos, gbufferProjectionInverse);
}

vec3 view_scenespace(vec3 viewpos, mat4 mvInv) {
    return viewMAD(mvInv, viewpos);
}

vec3 view_scenespace(vec3 viewpos) {
    return view_scenespace(viewpos, gbufferModelViewInverse);
}

#include "/lib/atmos/phase.glsl"

#include "/lib/atmos/asky.glsl"

#include "/lib/atmos/project.glsl"

void main() {
    vec4 return5    = vec4(0.0);

    if(!(coord.y >= exp2(-SKY_RENDER_LOD) || coord.x >= exp2(-SKY_RENDER_LOD))) {
        vec3 sceneDir = unprojectSky(coord);
        vec3 skycol   = scatter(sceneDir, mat2x3(sunvec, moonvec), atmos_multiscatter);
        return5     = vec4(skycol, 1.0);
    }

    vec2 coord_t    = coord-vec2(0.0, 0.3);

    if(!(coord_t.y >= exp2(-SKY_RENDER_LOD) || coord_t.x >= exp2(-SKY_RENDER_LOD)) && (coord_t.y>=0.0)) {
        vec3 sceneDir = unprojectSky(coord_t);
        vec3 skycol   = air_transmittance(vec3(0.0, planetRad*0.9998 + eyeAltitude, 0.0), sceneDir, 4);
        //vec3 skycol   = scatter(sceneDir, sunvec, moonvec, 16);
        return5 = vec4(skycol, 1.0);
    }

    /*DRAWBUFFERS:5*/
    gl_FragData[0]  = clamp_drawbuffer(return5);
}