#version 400 compatibility

/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.github.io/license/

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

#define skypass

#include "/lib/common.glsl"

out vec2 coord;

uniform float eyeAltitude;

uniform vec4 daytime;
uniform vec3 sunvec;
uniform vec3 moonvec;

uniform float wetness;

flat out vec3 atmos_multiscatter;
flat out vec3 atmos_upcol;

flat out mat4x3 light_color;

#include "/lib/atmos/phase.glsl"

#define atmos_fastpass

#include "/lib/atmos/asky.glsl"

void make_colors() {
    atmos_upcol     = scatter(vec3(0.0, 1.0, 0.0), mat2x3(sunvec, moonvec), vec3(0.0));

    atmos_multiscatter = atmos_upcol * 0.5 * rcp(pi);
    atmos_multiscatter = mix(atmos_multiscatter, vec3(atmos_multiscatter.z), 0.3);

    light_color[0]  = sun_illum * air_transmittance(vec3(0.0, planetRad + eyeAltitude, 0.0), sunvec, 5);
    light_color[1]  = scatter(vec3(0.0, 1.0, 0.0), mat2x3(sunvec, moonvec), atmos_multiscatter)*pi;
    light_color[2]  = vec3(0.0);
    light_color[3]  = vec3(0.5, 0.7, 1.0) * 0.04 * moon_illumination_mult;

    float moon_int  = sstep(dot(vec3(0.0, 1.0, 0.0), moonvec), 0.04, 0.1);

    light_color[3] *= moon_int;
}

void main() {
    gl_Position = vec4(gl_Vertex.xy * 2.0 - 1.0, 0.0, 1.0);
    coord = gl_MultiTexCoord0.xy;

    make_colors();
}