/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.github.io/license/

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

#include "/lib/common.glsl"
#include "/lib/util/srgb.glsl"
#include "/lib/util/encoders.glsl"

const int shadowMapResolution   = 2048;     //[512 1024 1536 2048 4560 3072 3584 4096 6144 8192 16384]

in mat2x2 coord;

in float warp;
in float view_dist;

in vec3 pos_shadow;
in vec3 world_pos;
in vec3 view_vec;

in vec4 tint;

flat in int mat_id;

flat in vec3 normal;

flat in float light_flip;

flat in mat3x3 tbn;

flat in mat4x3 light_color;

uniform sampler2D gcolor;

uniform sampler2D noisetex;

uniform int frameCounter;

uniform float sunAngle;
uniform float frameTimeCounter;

uniform vec2 viewSize;

uniform vec3 lightvec, lightvecView;
uniform vec3 cameraPosition;

uniform mat4 gbufferModelView, gbufferModelViewInverse;
uniform mat4 gbufferProjectionInverse;

uniform sampler2DShadow shadowtex0;
uniform sampler2DShadow shadowtex1;
uniform sampler2D shadowcolor0;

float encodeMatID16(int x) {
    float id    = float(x)/65535.0;
    return id;
}

vec3 screen_viewspace(vec3 screenpos, mat4 projInv) {
    screenpos   = screenpos*2.0-1.0;

    //screenpos.xy -= taaOffset;

    vec3 viewpos    = vec3(vec2(projInv[0].x, projInv[1].y)*screenpos.xy + projInv[3].xy, projInv[3].z);
        viewpos    /= projInv[2].w*screenpos.z + projInv[3].w;
    
    return viewpos;
}

vec3 screen_viewspace(vec3 screenpos) {
    return screen_viewspace(screenpos, gbufferProjectionInverse);
}

vec3 view_scenespace(vec3 viewpos, mat4 mvInv) {
    return viewMAD(mvInv, viewpos);
}

vec3 view_scenespace(vec3 viewpos) {
    return view_scenespace(viewpos, gbufferModelViewInverse);
}

float bayer2e(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}
#define bayer4e(a)   (bayer2e( .5*(a))*.25+bayer2e(a))

#define m vec3(31,63,31)
float encode3x8(vec3 a){
    float dither = bayer4e(gl_FragCoord.xy);
    a += (dither-.5) / m;
    a = saturate(a);
    ivec3 b = ivec3(a*m);
    return float( b.r|(b.g<<5)|(b.b<<11) ) / 65535.;
}
#undef m

#ifdef g_terrain
vec2 rotate_coord(vec2 pos, const float angle) {
    return vec2(cos(angle)*pos.x + sin(angle)*pos.y, 
                cos(angle)*pos.y - sin(angle)*pos.x);
}

vec4 textureBicubic(sampler2D sampler, vec2 coord) {
	vec2 res = textureSize(sampler, 0);

	coord = coord * res - 0.5;

	vec2 f = fract(coord);
	coord -= f;

	vec2 ff = f * f;
	vec4 w0;
	vec4 w1;
	w0.xz = 1 - f; w0.xz *= w0.xz * w0.xz;
	w1.yw = ff * f;
	w1.xz = 3 * w1.yw + 4 - 6 * ff;
	w0.yw = 6 - w1.xz - w1.yw - w0.xz;

	vec4 s = w0 + w1;
	vec4 c = coord.xxyy + vec2(-0.5, 1.5).xyxy + w1 / s;
	c /= res.xxyy;

	vec2 m = s.xz / (s.xz + s.yw);
	return mix(
		mix(texture(sampler, c.yw), texture(sampler, c.xw), m.x),
		mix(texture(sampler, c.yz), texture(sampler, c.xz), m.x),
		m.y);
}

#include "/lib/atmos/water_height.glsl"

#ifdef water_parallax_enabled
    vec3 water_parallax(vec3 pos) {
        vec3 viewpos    = view_scenespace(pos, gbufferModelView);
        vec3 rpos       = pos;

        const float weight  = ircp(float(water_parallax_steps)) * tau;

        float dfade     = 1.0 - sstep(distance(cameraPosition, pos), 48.0, 72.0);
        float height    = water_height(rpos) * weight * dfade;

        if (dfade < 0.001) return rpos;

        for (int i = 0; i<water_parallax_steps; i++) {
            rpos.xz    += height * view_vec.xy * rcp(view_dist);
            height      = water_height(rpos) * weight * dfade;
        }

        rpos.xz    += height * view_vec.xy * rcp(view_dist);

        return rpos;
    }
#endif

float value_3d(vec3 pos) {
    vec3 p  = floor(pos); 
    vec3 b  = fract(pos);

    vec2 uv = (p.xy+vec2(-97.0)*p.z)+b.xy;
    vec2 rg = texture(noisetex, (uv)/256.0).xy;

    return cube_smooth(mix(rg.x, rg.y, b.z));
}

vec3 water_normal() {
    vec3 offset[4] = vec3[4] ( 
            vec3(-1.0, 0.0, 0.0),
            vec3(1.0, 0.0, 0.0),
            vec3(0.0, 0.0, 1.0),
            vec3(0.0, 0.0, -1.0)
        );

    float delta_step = 0.02 + lin_step(view_dist, 16.0, 64.0)*0.4;

    #ifdef water_parallax_enabled
        vec3 pos        = water_parallax(world_pos);
    #else
        vec3 pos        = world_pos;
    #endif

    float hL        = water_height(pos+offset[0]*delta_step);
    float hR        = water_height(pos+offset[1]*delta_step);
    float hU        = water_height(pos+offset[2]*delta_step);
    float hD        = water_height(pos+offset[3]*delta_step);

    vec3 delta      = vec3(0.0, 0.0, 1.0);

        #ifdef water_normal_hq
            float h0    = water_height(pos);
            delta.x     = ((hL-h0)+(h0-hR))/delta_step;
            delta.y     = ((hU-h0)+(h0-hD))/delta_step;
        #else
            delta.x     = (hL-hR)/delta_step;
            delta.y     = (hU-hD)/delta_step;
        #endif

            delta.xy   *= 0.7;

        delta.z     = sqrt(1.0 - dot(delta.xy, delta.xy));

        //delta       = clamp(delta, -1, 1);

    return normalize(delta*tbn);
}
#endif

#include "/lib/light/diffuse.glsl"

float get_specGGX(vec3 normal, vec3 viewvec, vec3 lvec, float roughness) {
    const float f0  = 0.02;
    roughness  *= roughness;

    vec3 h      = lvec - viewvec;
    float hn    = inversesqrt(dot(h, h));
    float hDotL = saturate(dot(h, lvec)*hn);
    float hDotN = saturate(dot(h, normal)*hn);
    float nDotL = saturate(dot(normal, lvec));
    float denom = (hDotN * roughness - hDotN) * hDotN + 1.0;
    float D     = roughness / (pi * denom * denom);
    float F     = f0 + (1.0-f0) * exp2((-5.55473*hDotL-6.98316)*hDotL);
    float k2    = 0.25 * roughness;

    return nDotL * D * F / (hDotL * hDotL * (1.0-k2) + k2);
}

#include "/lib/frag/bluenoise.glsl"

#include "/lib/light/shadow.glsl"

vec3 get_lblock(vec3 lcol, float lmap) {
    return pow5(lmap)*lcol;
}

vec3 get_light(vec3 scenecol, vec3 normal, vec2 lmap, float ao) {
    float shadow    = 1.0;
    vec3 shadowcol  = vec3(1.0);

    vec2 fragcoord  = gl_FragCoord.xy * rcp(viewSize);

    vec3 svec       = screen_viewspace(vec3(fragcoord, gl_FragCoord.z));
        svec        = normalize(mat3(gbufferModelViewInverse)*normalize(-svec));

    float diff      = get_diffLambert(normal);

    get_ldirect(shadow, shadowcol, diff>0.0);

    float diff_lit  = min(diff, shadow);
    vec3 direct_col     = sunAngle<0.5 ? light_color[0] : light_color[3];

    vec3 specular       = get_specGGX(normal, -lightvec, svec, 0.015)*diff_lit*shadowcol * tau;
    if (sunAngle<0.5) specular *= 2.0;
        specular       *= direct_col*light_flip;

    vec3 direct_light   = diff_lit*shadowcol*direct_col*light_flip;
    vec3 indirect_light = pow5(lmap.y)*light_color[1] * 0.35 + pow3(lmap.y) * direct_col * 0.08;
        indirect_light += vec3(0.5, 0.7, 1.0)*0.01*minlight_luma;
        indirect_light *= ao;

    vec3 result     = direct_light + indirect_light;
        result     += get_lblock(light_color[2], lmap.x)*ao;

    return scenecol * result + specular;
}

void main() {
    vec4 scenecol   = texture(gcolor, coord[0]);
    vec3 scenenormal = normal;
    if (scenecol.a<0.02) discard;
        scenecol.rgb *= tint.rgb;

    scenecol.rgb    = to_linear(scenecol.rgb);

    #ifdef g_terrain
        #ifdef custom_water
        if (mat_id == 102) {
            scenecol.rgb = vec3(0.1);
            scenecol.a   = 0.15;
            scenenormal  = water_normal();
        }
        #endif

        #ifdef custom_ice
        if (mat_id == 103) {
            scenecol.rgb = vec3(0.2, 0.5, 0.9)*0.7;
            float icelum = value_3d(world_pos*4.0)*0.5;
                icelum  += value_3d(world_pos*24.0)*0.25;
            scenecol.rgb *= icelum * 0.5 + 0.5;
            scenecol.a   = 0.81;
            scenenormal  = water_normal();
        }
        #endif
    #endif

    vec3 hue    = normalize(scenecol.rgb);

    scenecol.rgb = get_light(scenecol.rgb, scenenormal, coord[1], tint.a);

    scenecol.rgb *= 1.0 + (1.0-scenecol.a);

    /*DRAWBUFFERS:312*/
    gl_FragData[0]  = make_drawbuffer(scenecol.rgb, saturate(scenecol.a));
    gl_FragData[1]  = vec4(encodeNormal(scenenormal), encode2x8(coord[1]), 1.0);
    gl_FragData[2]  = vec4(encodeMatID16(mat_id), encode3x8(hue), 0.0, 1.0);
}