#version 400 compatibility

/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.github.io/license/

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

#include "/lib/common.glsl"

const int noiseTextureResolution = 256;

in mat2x2 coord;

in float view_dist;

in vec3 world_pos;

in vec4 tint;

flat in int mat_id;

flat in vec3 normal;

uniform sampler2D gcolor;

uniform sampler2D noisetex;

uniform int blockEntityId;

uniform float frameTimeCounter;

uniform vec3 cameraPosition;


vec2 rotate_coord(vec2 pos, const float angle) {
    return vec2(cos(angle)*pos.x + sin(angle)*pos.y, 
                cos(angle)*pos.y - sin(angle)*pos.x);
}

vec4 textureBicubic(sampler2D sampler, vec2 coord) {
	vec2 res = textureSize(sampler, 0);

	coord = coord * res - 0.5;

	vec2 f = fract(coord);
	coord -= f;

	vec2 ff = f * f;
	vec4 w0;
	vec4 w1;
	w0.xz = 1 - f; w0.xz *= w0.xz * w0.xz;
	w1.yw = ff * f;
	w1.xz = 3 * w1.yw + 4 - 6 * ff;
	w0.yw = 6 - w1.xz - w1.yw - w0.xz;

	vec4 s = w0 + w1;
	vec4 c = coord.xxyy + vec2(-0.5, 1.5).xyxy + w1 / s;
	c /= res.xxyy;

	vec2 m = s.xz / (s.xz + s.yw);
	return mix(
		mix(texture(sampler, c.yw), texture(sampler, c.xw), m.x),
		mix(texture(sampler, c.yz), texture(sampler, c.xz), m.x),
		m.y);
}

#include "/lib/atmos/water_height.glsl"

vec3 water_normal() {
    vec3 offset[4] = vec3[4] ( 
            vec3(-1.0, 0.0, 0.0),
            vec3(1.0, 0.0, 0.0),
            vec3(0.0, 0.0, 1.0),
            vec3(0.0, 0.0, -1.0)
        );

    float delta_step = 0.02;

    vec3 pos        = world_pos;

    float hL        = water_height(pos+offset[0]*delta_step);
    float hR        = water_height(pos+offset[1]*delta_step);
    float hU        = water_height(pos+offset[2]*delta_step);
    float hD        = water_height(pos+offset[3]*delta_step);

    vec3 delta      = vec3(0.0, 0.0, 1.0);

        delta.x     = (hL-hR)/delta_step;
        delta.y     = (hU-hD)/delta_step;

        delta.z     = sqrt(1.0 - dot(delta.xy, delta.xy));

    return normalize(delta);
}

float get_caustic() {
    return cube_smooth(saturate(length(water_normal().xy) * 2.0));
    //return pow6(saturate(water_height(world_pos)*4.0));
}

void main() {
    if (blockEntityId == 10201) discard;
    vec4 scenecol   = texture(gcolor, coord[0]);
        scenecol.rgb *= tint.rgb;

    if (mat_id == 102) {
        scenecol    = vec4(1.0, 1.0, 1.0, 0.1);
    }

    if (scenecol.a<0.9) scenecol.a = saturate((scenecol.a - 0.1)*0.88 + 0.1);

    if (mat_id == 102) {
        #ifdef water_caustic
            float d     = distance(world_pos.xz, cameraPosition.xz);
                d       = lin_step(d, 64.0, 96.0);
            
            float caustic = 0.25;

            if (d < 1.0) {
                caustic = get_caustic();
                caustic = mix(caustic, 0.25, d);
            }

            scenecol    = vec4(1.0, 1.0, 1.0, 0.95);

            scenecol    = mix(vec4(0.5, 0.5, 0.5, 0.95), scenecol, saturate((caustic)));
        #else
            scenecol    = vec4(1.0, 1.0, 1.0, 0.11);
        #endif
    }

    gl_FragData[0]  = scenecol;
}