/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.client.render;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtil {
    public static <T extends LivingEntity> void renderGlowing(RendererModel modelPart, float brightness, T entity, float scale) {
        RenderUtil.startGlowing(entity.func_82150_aj(), brightness);
        modelPart.func_78785_a(scale);
        RenderUtil.endGlowing(entity.func_70070_b());
    }

    public static <T extends LivingEntity> void renderGlowing(IEntityRenderer<T, EntityModel<T>> render, ResourceLocation texture, float brightness, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        render.func_110776_a(texture);
        render.func_110776_a(texture);
        RenderUtil.startGlowing(entity.func_82150_aj(), brightness);
        render.func_217764_d().func_78088_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        RenderUtil.endGlowing(entity.func_70070_b());
    }

    private static void startGlowing(boolean entityInvisible, float brightness) {
        GlStateManager.enableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        if (entityInvisible) {
            GlStateManager.depthMask((boolean)false);
        } else {
            GlStateManager.depthMask((boolean)true);
        }
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)brightness, (float)0.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
    }

    private static void endGlowing(int brightnessForRender) {
        Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
        int j = brightnessForRender % 65536;
        int k = brightnessForRender / 65536;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
        GlStateManager.disableBlend();
    }
}

