/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.network;

import com.google.common.collect.ImmutableCollection;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.network.IMessage;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateEntityPacket
implements IMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private int id;
    private CompoundNBT data;
    private CompoundNBT caps;
    private boolean playerItself = false;

    static void encode(UpdateEntityPacket msg, PacketBuffer buf) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("id", msg.id);
        if (msg.data != null) {
            tag.func_218657_a("data", (INBT)msg.data);
        }
        if (msg.caps != null) {
            tag.func_218657_a("caps", (INBT)msg.caps);
        }
        if (msg.playerItself) {
            tag.func_74757_a("itself", true);
        }
        buf.func_150786_a(tag);
    }

    static UpdateEntityPacket decode(PacketBuffer buf) {
        CompoundNBT tag = buf.func_150793_b();
        UpdateEntityPacket pkt = new UpdateEntityPacket();
        pkt.id = tag.func_74762_e("id");
        if (tag.func_74764_b("data")) {
            pkt.data = tag.func_74775_l("data");
        }
        if (tag.func_74764_b("caps")) {
            pkt.caps = tag.func_74775_l("caps");
        }
        if (tag.func_74764_b("itself")) {
            pkt.playerItself = tag.func_74767_n("itself");
        }
        return pkt;
    }

    public static void handle(UpdateEntityPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampLib.proxy.handleUpdateEntityPacket(message));
        ctx.setPacketHandled(true);
    }

    public static UpdateEntityPacket create(ISyncable.ISyncableEntityCapabilityInst cap) {
        CompoundNBT data = new CompoundNBT();
        cap.writeFullUpdateToNBT(data);
        return UpdateEntityPacket.create(cap, data);
    }

    public static UpdateEntityPacket create(MobEntity entity, ISyncable.ISyncableEntityCapabilityInst ... caps) {
        if (!(entity instanceof ISyncable)) {
            throw new IllegalArgumentException("You cannot use this packet to sync this entity. The entity has to implement ISyncable");
        }
        UpdateEntityPacket packet = UpdateEntityPacket.create(caps);
        packet.data = new CompoundNBT();
        ((ISyncable)entity).writeFullUpdateToNBT(packet.data);
        return packet;
    }

    public static UpdateEntityPacket create(ISyncable.ISyncableEntityCapabilityInst ... caps) {
        UpdateEntityPacket packet = new UpdateEntityPacket();
        packet.id = caps[0].getTheEntityID();
        packet.caps = new CompoundNBT();
        for (ISyncable.ISyncableEntityCapabilityInst cap : caps) {
            CompoundNBT data = new CompoundNBT();
            cap.writeFullUpdateToNBT(data);
            packet.caps.func_218657_a(cap.getCapKey().toString(), (INBT)data);
        }
        return packet;
    }

    public static UpdateEntityPacket create(ISyncable.ISyncableEntityCapabilityInst cap, CompoundNBT data) {
        UpdateEntityPacket packet = new UpdateEntityPacket();
        packet.id = cap.getTheEntityID();
        packet.caps = new CompoundNBT();
        packet.caps.func_218657_a(cap.getCapKey().toString(), (INBT)data);
        return packet;
    }

    public static UpdateEntityPacket create(Entity entity) {
        if (!(entity instanceof ISyncable)) {
            throw new IllegalArgumentException("You cannot use this packet to sync this entity. The entity has to implement ISyncable");
        }
        UpdateEntityPacket packet = new UpdateEntityPacket();
        packet.id = entity.func_145782_y();
        packet.data = new CompoundNBT();
        ((ISyncable)entity).writeFullUpdateToNBT(packet.data);
        return packet;
    }

    public static UpdateEntityPacket create(Entity entity, CompoundNBT data) {
        if (!(entity instanceof ISyncable)) {
            throw new IllegalArgumentException("You cannot use this packet to sync this entity. The entity has to implement ISyncable");
        }
        UpdateEntityPacket packet = new UpdateEntityPacket();
        packet.id = entity.func_145782_y();
        packet.data = data;
        return packet;
    }

    @Nullable
    public static UpdateEntityPacket createJoinWorldPacket(Entity entity) {
        ArrayList capsToSync = new ArrayList();
        ImmutableCollection allCaps = null;
        if (entity instanceof CreatureEntity) {
            allCaps = HelperRegistry.getSyncableEntityCaps().values();
        } else if (entity instanceof PlayerEntity) {
            allCaps = HelperRegistry.getSyncablePlayerCaps().values();
        }
        if (allCaps != null && allCaps.size() > 0) {
            for (Capability cap : allCaps) {
                entity.getCapability(cap, null).ifPresent(inst -> capsToSync.add((ISyncable.ISyncableEntityCapabilityInst)inst));
            }
        }
        if (capsToSync.size() > 0) {
            if (entity instanceof ISyncable) {
                return UpdateEntityPacket.create((MobEntity)entity, capsToSync.toArray(new ISyncable.ISyncableEntityCapabilityInst[0]));
            }
            return UpdateEntityPacket.create(capsToSync.toArray(new ISyncable.ISyncableEntityCapabilityInst[0]));
        }
        if (entity instanceof ISyncable) {
            return UpdateEntityPacket.create(entity);
        }
        LOGGER.warn("There is nothing to update for entity {}", (Object)entity);
        return null;
    }

    public CompoundNBT getCaps() {
        return this.caps;
    }

    public CompoundNBT getData() {
        return this.data;
    }

    public int getId() {
        return this.id;
    }

    public boolean isPlayerItself() {
        return this.playerItself;
    }

    public UpdateEntityPacket markAsPlayerItself() {
        this.playerItself = true;
        return this;
    }
}

