/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.skills;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class DefaultSkill<T extends IFactionPlayer>
extends ForgeRegistryEntry<ISkill>
implements ISkill {
    private final Map<IAttribute, AttributeModifier> attributeModifierMap = new HashMap<IAttribute, AttributeModifier>();
    private final IPlayableFaction<T> faction;
    private int renderRow;
    private int renderColumn;
    private String translationKey;

    protected DefaultSkill(IPlayableFaction<T> faction) {
        this.faction = faction;
    }

    @Override
    @Nonnull
    public IPlayableFaction getFaction() {
        return this.faction;
    }

    @Override
    public int getRenderColumn() {
        return this.renderColumn;
    }

    @Override
    public int getRenderRow() {
        return this.renderRow;
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey == null ? (this.translationKey = "skill." + this.getRegistryName().func_110624_b() + "." + this.getRegistryName().func_110623_a()) : this.translationKey;
    }

    @Override
    public final void onDisable(IFactionPlayer player) {
        this.removeAttributesModifiersFromEntity(player.getRepresentingPlayer());
        player.getActionHandler().relockActions(this.getActions());
        if (!this.faction.getFactionPlayerInterface().isInstance(player)) {
            throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.faction.getFactionPlayerInterface());
        }
        this.onDisabled(player);
    }

    @Override
    public final void onEnable(IFactionPlayer player) {
        this.applyAttributesModifiersToEntity(player.getRepresentingPlayer());
        player.getActionHandler().unlockActions(this.getActions());
        if (!this.faction.getFactionPlayerInterface().isInstance(player)) {
            throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.faction.getFactionPlayerInterface());
        }
        this.onEnabled(player);
    }

    public DefaultSkill<T> registerAttributeModifier(IAttribute attribute, String uuid, double amount, AttributeModifier.Operation operation) {
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString(uuid), this.getRegistryName().toString(), amount, operation);
        this.attributeModifierMap.put(attribute, attributemodifier);
        return this;
    }

    @Override
    public void setRenderPos(int row, int column) {
        this.renderRow = row;
        this.renderColumn = column;
    }

    public String toString() {
        return this.getRegistryName() + "(" + this.getClass().getSimpleName() + ")";
    }

    protected void getActions(Collection<IAction> list) {
    }

    protected void onDisabled(T player) {
    }

    protected void onEnabled(T player) {
    }

    private void applyAttributesModifiersToEntity(PlayerEntity player) {
        for (Map.Entry<IAttribute, AttributeModifier> entry : this.attributeModifierMap.entrySet()) {
            IAttributeInstance iattributeinstance = player.func_110140_aT().func_111151_a(entry.getKey());
            if (iattributeinstance == null) continue;
            AttributeModifier attributemodifier = entry.getValue();
            iattributeinstance.func_111124_b(attributemodifier);
            iattributeinstance.func_111121_a(new AttributeModifier(attributemodifier.func_111167_a(), this.getRegistryName().toString(), attributemodifier.func_111164_d(), attributemodifier.func_220375_c()));
        }
    }

    private Collection<IAction> getActions() {
        ArrayList<IAction> collection = new ArrayList<IAction>();
        this.getActions(collection);
        collection.forEach(iAction -> {
            if (!iAction.getFaction().equals(this.getFaction())) {
                throw new IllegalArgumentException("Can't register action of faction " + iAction.getFaction() + " for skill of faction" + this.getFaction());
            }
        });
        return collection;
    }

    private void removeAttributesModifiersFromEntity(PlayerEntity player) {
        for (Map.Entry<IAttribute, AttributeModifier> entry : this.attributeModifierMap.entrySet()) {
            IAttributeInstance iattributeinstance = player.func_110140_aT().func_111151_a(entry.getKey());
            if (iattributeinstance == null) continue;
            iattributeinstance.func_111124_b(entry.getValue());
        }
    }
}

