/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.event;

import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class VampirismVillageEvent
extends Event {

    public static class UpdateBoundingBox
    extends VampirismVillageEvent {
        @Nonnull
        private final MutableBoundingBox bb;

        public UpdateBoundingBox(@Nonnull MutableBoundingBox bb) {
            this.bb = bb;
        }

        @Nonnull
        public MutableBoundingBox getBoundingBox() {
            return this.bb;
        }
    }

    @Event.HasResult
    public static class InitiateCapture
    extends VampirismVillageEvent {
        @Nonnull
        private final World world;
        @Nullable
        private final IPlayableFaction<?> controllingFaction;
        @Nonnull
        private final IPlayableFaction<?> capturingFaction;

        public InitiateCapture(@Nonnull World world, @Nullable IPlayableFaction<?> controllingFaction, @Nonnull IPlayableFaction<?> capturingFaction) {
            this.world = world;
            this.controllingFaction = controllingFaction;
            this.capturingFaction = capturingFaction;
        }

        @Nonnull
        public World getWorld() {
            return this.world;
        }

        @Nullable
        public IPlayableFaction<?> getControllingFaction() {
            return this.controllingFaction;
        }

        @Nonnull
        public IPlayableFaction<?> getCapturingFaction() {
            return this.capturingFaction;
        }
    }

    public static class ReplaceBlock
    extends VampirismVillageEvent {
        @Nonnull
        private final World world;
        @Nonnull
        private final BlockState state;
        @Nonnull
        private final IFaction<?> faction;
        @Nonnull
        private final BlockPos pos;

        public ReplaceBlock(@Nonnull World world, @Nonnull BlockState b, @Nonnull BlockPos pos, @Nonnull IFaction<?> controllingFaction) {
            this.world = world;
            this.state = b;
            this.faction = controllingFaction;
            this.pos = pos;
        }

        @Nonnull
        public World getWorld() {
            return this.world;
        }

        @Nonnull
        public BlockState getState() {
            return this.state;
        }

        @Nonnull
        public IFaction<?> getFaction() {
            return this.faction;
        }

        @Nonnull
        public BlockPos getBlockPos() {
            return this.pos;
        }
    }

    public static class SpawnFactionVillager
    extends VampirismVillageEvent {
        @Nonnull
        private final IPlayableFaction<?> faction;
        @Nonnull
        private final VillagerEntity seed;
        private VillagerEntity newVillager;
        private boolean poisonousBlood;

        public SpawnFactionVillager(@Nonnull VillagerEntity seed, @Nonnull IPlayableFaction<?> faction) {
            this.faction = faction;
            this.seed = seed;
        }

        @Nonnull
        public IPlayableFaction<?> getFaction() {
            return this.faction;
        }

        @Nonnull
        public VillagerEntity getSeed() {
            return this.seed;
        }

        @Nullable
        public VillagerEntity getVillager() {
            return this.newVillager;
        }

        public void setVillager(VillagerEntity villager) {
            this.newVillager = villager;
        }

        public boolean hasPoisonousBlood() {
            return this.poisonousBlood;
        }

        public void setPoisonousBlood(boolean poisonous) {
            this.poisonousBlood = poisonous;
        }
    }

    public static class SpawnCaptureEntity
    extends VampirismVillageEvent {
        @Nonnull
        private final IFaction<?> faction;
        private EntityType<? extends MobEntity> entity;

        public SpawnCaptureEntity(@Nonnull IFaction<?> f) {
            this.faction = f;
        }

        @Nonnull
        public IFaction<?> getFaction() {
            return this.faction;
        }

        public void setEntity(EntityType<? extends MobEntity> entity) {
            this.entity = entity;
        }

        @Nullable
        public EntityType<? extends MobEntity> getEntity() {
            return this.entity;
        }
    }

    @Event.HasResult
    public static class VillagerCaptureFinish
    extends VampirismVillageEvent {
        @Nonnull
        private final List<VillagerEntity> villager;
        @Nullable
        private final IPlayableFaction<?> controllingFaction;
        @Nonnull
        private final IPlayableFaction<?> capturingFaction;
        @Nonnull
        private final AxisAlignedBB affectedArea;

        public VillagerCaptureFinish(@Nonnull List<VillagerEntity> villagerIn, @Nullable IPlayableFaction<?> controllingFactionIn, @Nonnull IPlayableFaction<?> capturingFactionIn, @Nonnull AxisAlignedBB affectedAreaIn) {
            this.villager = villagerIn;
            this.controllingFaction = controllingFactionIn;
            this.capturingFaction = capturingFactionIn;
            this.affectedArea = affectedAreaIn;
        }

        @Nonnull
        public List<VillagerEntity> getVillager() {
            return this.villager;
        }

        @Nullable
        public IPlayableFaction<?> getControllingFaction() {
            return this.controllingFaction;
        }

        @Nonnull
        public IPlayableFaction<?> getCapturingFaction() {
            return this.capturingFaction;
        }

        @Nonnull
        public AxisAlignedBB getAffectedArea() {
            return this.affectedArea;
        }
    }

    @Cancelable
    public static class MakeAggressive
    extends VampirismVillageEvent {
        private final VillagerEntity oldVillager;
        @Nullable
        private IVillageCaptureEntity captureVillager;

        public MakeAggressive(@Nonnull VillagerEntity villager) {
            this.oldVillager = villager;
        }

        @Nullable
        public IVillageCaptureEntity getAggressiveVillager() {
            return this.captureVillager;
        }

        public <T extends VillagerEntity> void setAggressiveVillager(@Nullable T captureVillager) {
            this.captureVillager = (IVillageCaptureEntity)captureVillager;
        }

        public VillagerEntity getOldVillager() {
            return this.oldVillager;
        }
    }

    @Event.HasResult
    public static class SpawnNewVillager
    extends VampirismVillageEvent {
        @Nonnull
        private final VillagerEntity seedVillager;
        @Nullable
        private VillagerEntity newVillager;
        private boolean willBeConverted;
        private final IPlayableFaction<?> faction;

        public SpawnNewVillager(@Nonnull VillagerEntity seedVillager, boolean willBeConverted, IPlayableFaction<?> faction) {
            this.seedVillager = seedVillager;
            this.willBeConverted = willBeConverted;
            this.faction = faction;
        }

        public VillagerEntity getNewVillager() {
            return this.newVillager;
        }

        public void setNewVillager(VillagerEntity newVillager) {
            this.newVillager = newVillager;
        }

        @Nonnull
        public VillagerEntity getSeedVillager() {
            return this.seedVillager;
        }

        public boolean isWillBeConverted() {
            return this.willBeConverted;
        }

        public void setWillBeConverted(boolean willBeConverted) {
            this.willBeConverted = willBeConverted;
        }

        public IPlayableFaction<?> getFaction() {
            return this.faction;
        }
    }
}

