/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.ImmutableMap;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.tileentity.CoffinTileEntity;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeDimension;

public class CoffinBlock
extends VampirismBlockContainer {
    public static final String name = "coffin";
    public static final EnumProperty<CoffinPart> PART = EnumProperty.func_177709_a((String)"part", CoffinPart.class);
    private static final VoxelShape shape = CoffinBlock.makeShape();
    private static final Map<PlayerEntity.SleepResult, ITextComponent> sleepResults = ImmutableMap.of((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_NOW, (Object)new TranslationTextComponent("text.vampirism.coffin.no_sleep", new Object[0]), (Object)PlayerEntity.SleepResult.TOO_FAR_AWAY, (Object)new TranslationTextComponent("text.vampirism.coffin.too_far_away", new Object[0]), (Object)PlayerEntity.SleepResult.OBSTRUCTED, (Object)new TranslationTextComponent("text.vampirism.coffin.obstructed", new Object[0]));

    public static boolean isOccupied(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof CoffinBlock && (Boolean)state.func_177229_b((IProperty)BedBlock.field_176471_b) != false;
    }

    public static boolean isHead(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof CoffinBlock && state.func_177229_b(PART) == CoffinPart.HEAD;
    }

    private static Direction getDirectionToOther(CoffinPart type, Direction facing) {
        return type == CoffinPart.FOOT ? facing : facing.func_176734_d();
    }

    private static VoxelShape makeShape() {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    }

    public CoffinBlock() {
        super(name, Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(0.2f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BedBlock.field_176471_b, (Comparable)Boolean.FALSE)).func_206870_a(PART, (Comparable)((Object)CoffinPart.FOOT))).func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH));
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, PathType type) {
        return false;
    }

    public TileEntity func_196283_a_(@Nonnull IBlockReader worldIn) {
        return new CoffinTileEntity();
    }

    public Direction getBedDirection(BlockState state, IWorldReader world, BlockPos pos) {
        return (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
    }

    @Nonnull
    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return shape;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction enumfacing = context.func_195992_f();
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(enumfacing);
        return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)enumfacing) : null;
    }

    public boolean isBed(BlockState state, IBlockReader world, BlockPos pos, Entity player) {
        return true;
    }

    public boolean isBedFoot(BlockState state, IWorldReader world, BlockPos pos) {
        return state.func_177229_b(PART) == CoffinPart.FOOT;
    }

    public boolean func_220081_d(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos) {
        return false;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Direction enumfacing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        if (state.func_177229_b(PART) == CoffinPart.HEAD) {
            if (worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_177230_c() != this) {
                worldIn.func_217377_a(pos, isMoving);
            }
        } else if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this) {
            worldIn.func_217377_a(pos, isMoving);
            if (!worldIn.func_201670_d()) {
                Block.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            }
        }
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof DyeItem) {
            TileEntity other;
            CoffinTileEntity tile = (CoffinTileEntity)worldIn.func_175625_s(pos);
            TileEntity tileEntity = other = state.func_177229_b(PART) == CoffinPart.HEAD ? worldIn.func_175625_s(pos.func_177972_a(((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176734_d())) : worldIn.func_175625_s(pos.func_177972_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)));
            if (!(other instanceof CoffinTileEntity)) {
                return true;
            }
            tile.changeColor(((DyeItem)heldItem.func_77973_b()).func_195962_g());
            ((CoffinTileEntity)other).changeColor(((DyeItem)heldItem.func_77973_b()).func_195962_g());
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            return true;
        }
        if (state.func_177229_b(PART) != CoffinPart.HEAD && (state = worldIn.func_180495_p(pos = pos.func_177972_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)))).func_177230_c() != this) {
            return true;
        }
        if ((Integer)VampirePlayer.getOpt(player).map(VampirismPlayer::getLevel).orElse((Object)0) == 0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.coffin.cant_use", new Object[0]), true);
            return true;
        }
        IForgeDimension.SleepResult sleepResult = worldIn.field_73011_w.canSleepAt(player, pos);
        if (sleepResult != IForgeDimension.SleepResult.BED_EXPLODES) {
            if (sleepResult == IForgeDimension.SleepResult.DENY) {
                return true;
            }
            if (((Boolean)state.func_177229_b((IProperty)BedBlock.field_176471_b)).booleanValue()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.coffin.occupied", new Object[0]), true);
                return true;
            }
            BlockPos finalPos = pos;
            player.func_213819_a(pos).ifLeft(sleepResult1 -> {
                if (sleepResult1 != null) {
                    player.func_146105_b(sleepResults.getOrDefault(sleepResult1, sleepResult1.func_221259_a()), true);
                }
            }).ifRight(u -> {
                BlockState blockstate = worldIn.func_180495_p(finalPos);
                if (blockstate.func_177230_c() instanceof CoffinBlock) {
                    worldIn.func_180501_a(finalPos, (BlockState)blockstate.func_206870_a((IProperty)BedBlock.field_176471_b, (Comparable)Boolean.TRUE), 3);
                }
            });
            return true;
        }
        worldIn.func_217377_a(pos, false);
        BlockPos blockPos = pos.func_177972_a(((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176734_d());
        if (worldIn.func_180495_p(blockPos).func_177230_c() == this) {
            worldIn.func_217377_a(blockPos, false);
        }
        worldIn.func_217401_a(null, DamageSource.func_199683_a(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, @Nonnull PlayerEntity player) {
        CoffinPart part = (CoffinPart)((Object)state.func_177229_b(PART));
        BlockPos blockpos = pos.func_177972_a(CoffinBlock.getDirectionToOther(part, (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)));
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && blockstate.func_177229_b(PART) != part) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                ItemStack itemstack = player.func_184614_ca();
                CoffinBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)itemstack);
                CoffinBlock.func_220054_a((BlockState)blockstate, (World)worldIn, (BlockPos)blockpos, null, (Entity)player, (ItemStack)itemstack);
            }
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack itemStack) {
        super.func_180633_a(worldIn, pos, state, entity, itemStack);
        if (!worldIn.field_72995_K) {
            BlockPos blockpos = pos.func_177972_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J));
            worldIn.func_180501_a(blockpos, (BlockState)state.func_206870_a(PART, (Comparable)((Object)CoffinPart.HEAD)), 3);
            worldIn.func_195592_c(pos, Blocks.field_150350_a);
            state.func_196946_a((IWorld)worldIn, pos, 3);
        }
    }

    @Nonnull
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == CoffinBlock.getDirectionToOther((CoffinPart)((Object)stateIn.func_177229_b(PART)), (Direction)stateIn.func_177229_b((IProperty)BlockStateProperties.field_208157_J))) {
            return facingState.func_177230_c() == this && facingState.func_177229_b(PART) != stateIn.func_177229_b(PART) ? (BlockState)stateIn.func_206870_a((IProperty)BedBlock.field_176471_b, facingState.func_177229_b((IProperty)BedBlock.field_176471_b)) : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208157_J, BedBlock.field_176471_b, PART});
    }

    @Nullable
    private PlayerEntity getPlayerInCoffin(World worldIn, BlockPos pos) {
        for (PlayerEntity entityplayer : worldIn.func_217369_A()) {
            if (!entityplayer.func_70608_bn() || !entityplayer.getBedLocation(worldIn.func_201675_m().func_186058_p()).equals((Object)pos)) continue;
            return entityplayer;
        }
        return null;
    }

    public static enum CoffinPart implements IStringSerializable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private CoffinPart(String name) {
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

