/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.tileentity.GarlicBeaconTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GarlicBeaconBlock
extends VampirismBlockContainer {
    public static final String regName = "garlic_beacon";
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.07, 0.0, 0.07, 0.93, 0.75, 0.93);
    private static final VoxelShape shape = GarlicBeaconBlock.makeShape();
    private final Type type;

    private static VoxelShape makeShape() {
        VoxelShape a = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        VoxelShape b = Block.func_208617_a((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
        return VoxelShapes.func_197872_a((VoxelShape)a, (VoxelShape)b);
    }

    public GarlicBeaconBlock(Type type) {
        super("garlic_beacon_" + type.func_176610_l(), Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.0f).func_200947_a(SoundType.field_185851_d));
        this.type = type;
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        if (this.type == Type.WEAK || this.type == Type.IMPROVED) {
            tooltip.add(new TranslationTextComponent(this.func_149739_a() + "." + this.type.func_176610_l(), new Object[0]).func_211708_a(TextFormatting.AQUA));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("block.vampirism.garlic_beacon.tooltip1", new Object[0]));
        int c = 1 + 2 * (this.type == Type.IMPROVED ? (Integer)VampirismConfig.BALANCE.hsGarlicDiffusorEnhancedDist.get() : (this.type == Type.WEAK ? (Integer)VampirismConfig.BALANCE.hsGarlicDiffusorWeakDist.get() : (Integer)VampirismConfig.BALANCE.hsGarlicDiffusorNormalDist.get()));
        tooltip.add((ITextComponent)new TranslationTextComponent("block.vampirism.garlic_beacon.tooltip2", new Object[]{c, c}));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        GarlicBeaconTileEntity tile = new GarlicBeaconTileEntity();
        tile.setType(this.type);
        return tile;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return shape;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f());
    }

    public String func_149739_a() {
        return "block.vampirism.garlic_beacon";
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (te != null && te instanceof GarlicBeaconTileEntity) {
            ((GarlicBeaconTileEntity)te).onTouched(player);
        }
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && ((Object)((Object)ModItems.purified_garlic)).equals(heldItem.func_77973_b())) {
            GarlicBeaconTileEntity t;
            if (!world.field_72995_K && (t = this.getTile((IBlockReader)world, pos)) != null) {
                if (t.getFuelTime() > 0) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("tile.vampirism.garlic_beacon.already_fueled", new Object[0]));
                } else {
                    t.onFueled();
                    if (!player.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("tile.vampirism.garlic_beacon.successfully_fueled", new Object[0]));
                }
            }
            return true;
        }
        return false;
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn) {
        GarlicBeaconTileEntity tile = this.getTile((IBlockReader)worldIn, pos);
        if (tile != null) {
            tile.onTouched(playerIn);
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    @Nullable
    private GarlicBeaconTileEntity getTile(IBlockReader world, BlockPos pos) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof GarlicBeaconTileEntity) {
            return (GarlicBeaconTileEntity)t;
        }
        return null;
    }

    public static enum Type implements IStringSerializable
    {
        NORMAL("normal", 0),
        IMPROVED("improved", 1),
        WEAK("weak", 2);

        private final String name;
        private final int id;

        private Type(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

