/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import de.teamlapen.vampirism.client.model.blocks.BakedAltarInspirationModel;
import de.teamlapen.vampirism.client.model.blocks.BakedBloodContainerModel;
import de.teamlapen.vampirism.client.model.blocks.BakedWeaponTableModel;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.util.Helper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.fluid.EmptyFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onModelBakeEvent(ModelBakeEvent event) {
        IUnbakedModel model;
        Object newModel;
        IBakedModel registeredModel;
        ArrayList modelLocations;
        IModel[] containerFluidModels = new IModel[14];
        try {
            for (int x = 0; x < 14; ++x) {
                containerFluidModels[x] = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("vampirism", "block/blood_container/fluid_" + (x + 1)));
            }
            for (Fluid f : ForgeRegistries.FLUIDS) {
                if (f instanceof EmptyFluid) continue;
                for (int x = 0; x < 14; ++x) {
                    IModel retexturedModel = containerFluidModels[x].retexture(new ImmutableMap.Builder().put((Object)"fluid", (Object)f.getAttributes().getStill(null).toString()).build());
                    BakedBloodContainerModel.FLUID_MODELS[x].put(f, retexturedModel.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)ModelRotation.X0_Y0, Attributes.DEFAULT_BAKED_FORMAT));
                }
            }
            Map registry = event.getModelRegistry();
            modelLocations = Lists.newArrayList();
            for (ResourceLocation modelLoc : registry.keySet()) {
                if (!modelLoc.func_110624_b().equals("vampirism") || !modelLoc.func_110623_a().equals("blood_container")) continue;
                modelLocations.add(modelLoc);
            }
            for (ResourceLocation loc : modelLocations) {
                registeredModel = (IBakedModel)event.getModelRegistry().get(loc);
                newModel = new BakedBloodContainerModel(registeredModel);
                event.getModelRegistry().put(loc, newModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load fluid models for blood container", (Throwable)e);
        }
        try {
            for (int x = 0; x < 10; ++x) {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("vampirism", "block/altar_inspiration/blood" + (x + 1)));
                BakedAltarInspirationModel.FLUID_MODELS[x] = model.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)ModelRotation.X0_Y0, Attributes.DEFAULT_BAKED_FORMAT);
            }
            Map registry = event.getModelRegistry();
            modelLocations = Lists.newArrayList();
            for (ResourceLocation modelLoc : registry.keySet()) {
                if (!modelLoc.func_110624_b().equals("vampirism") || !modelLoc.func_110623_a().equals("altar_inspiration")) continue;
                modelLocations.add(modelLoc);
            }
            for (ResourceLocation loc : modelLocations) {
                registeredModel = (IBakedModel)event.getModelRegistry().get(loc);
                newModel = new BakedAltarInspirationModel(registeredModel);
                event.getModelRegistry().put(loc, newModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load fluid models for altar inspiration", (Throwable)e);
        }
        try {
            for (int x = 0; x < 5; ++x) {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("vampirism", "block/weapon_table/weapon_table_lava" + (x + 1)));
                BakedWeaponTableModel.FLUID_MODELS[x][0] = model.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)ModelRotation.X0_Y180, Attributes.DEFAULT_BAKED_FORMAT);
                BakedWeaponTableModel.FLUID_MODELS[x][1] = model.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)ModelRotation.X0_Y270, Attributes.DEFAULT_BAKED_FORMAT);
                BakedWeaponTableModel.FLUID_MODELS[x][2] = model.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)ModelRotation.X0_Y0, Attributes.DEFAULT_BAKED_FORMAT);
                BakedWeaponTableModel.FLUID_MODELS[x][3] = model.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)ModelRotation.X0_Y90, Attributes.DEFAULT_BAKED_FORMAT);
            }
            Map registry = event.getModelRegistry();
            modelLocations = Lists.newArrayList();
            for (ResourceLocation modelLoc : registry.keySet()) {
                if (!modelLoc.func_110624_b().equals("vampirism") || !modelLoc.func_110623_a().equals("weapon_table")) continue;
                modelLocations.add(modelLoc);
            }
            for (ResourceLocation loc : modelLocations) {
                registeredModel = (IBakedModel)event.getModelRegistry().get(loc);
                newModel = new BakedWeaponTableModel(registeredModel);
                event.getModelRegistry().put(loc, newModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load fluid models for weapon crafting table", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onFovOffsetUpdate(FOVUpdateEvent event) {
        if (((Boolean)VampirismConfig.CLIENT.disableFovChange.get()).booleanValue() && Helper.isVampire(event.getEntity())) {
            IAttributeInstance speed = event.getEntity().func_110148_a(SharedMonsterAttributes.field_111263_d);
            AttributeModifier vampirespeed = speed.func_111127_a(LevelAttributeModifier.getUUID(SharedMonsterAttributes.field_111263_d));
            if (vampirespeed == null) {
                return;
            }
            event.setNewfov((float)((double)event.getFov() * ((vampirespeed.func_111164_d() + 1.0) * (double)event.getEntity().field_71075_bZ.func_75094_b() + speed.func_111126_e()) / ((vampirespeed.func_111164_d() + 1.0) * ((double)event.getEntity().field_71075_bZ.func_75094_b() + speed.func_111126_e()))));
        }
    }
}

