/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.inventory.container.HunterBasicContainer;
import de.teamlapen.vampirism.network.InputEventPacket;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HunterBasicScreen
extends ContainerScreen<HunterBasicContainer> {
    private static final ResourceLocation guiTexture = new ResourceLocation("vampirism", "textures/gui/hunter_basic.png");
    private Button buttonLevelup;
    private int missing = 0;
    private int timer = 0;

    public HunterBasicScreen(HunterBasicContainer inventorySlotsIn, PlayerInventory playerInventory, ITextComponent name) {
        super((Container)inventorySlotsIn, playerInventory, name);
    }

    public void init() {
        super.init();
        String name = I18n.func_135052_a((String)"text.vampirism.level_up", (Object[])new Object[0]);
        int wid = this.font.func_78256_a(name) + 5;
        int i = (this.field_146999_f - wid) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.buttonLevelup = new Button(this.field_147003_i + i, j + 50, wid, 20, name, context -> {
            VampirismMod.dispatcher.sendToServer(new InputEventPacket("bl", ""));
            this.onClose();
        });
        this.addButton((Widget)this.buttonLevelup);
        this.buttonLevelup.active = false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void tick() {
        super.tick();
        this.timer = (this.timer + 1) % 10;
        if (this.timer == 0) {
            this.missing = ((HunterBasicContainer)this.field_147002_h).getMissingCount();
            this.buttonLevelup.active = this.missing == 0;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(guiTexture);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 94), 0x404040);
        String text = null;
        if (this.missing == 0) {
            text = UtilLib.translate("text.vampirism.basic_hunter.i_will_train_you", new Object[0]);
        } else if (this.missing > 0) {
            text = UtilLib.translate("text.vampirism.basic_hunter.pay_n_vampire_blood_more", this.missing);
        }
        if (text != null) {
            this.font.func_78279_b(text, 50, 12, 120, 0);
        }
    }
}

