/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import de.teamlapen.lib.lib.client.render.RenderUtil;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerVampirePlayerHead
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private final ResourceLocation[] eyeOverlays = new ResourceLocation[16];
    private final ResourceLocation[] fangOverlays;

    public LayerVampirePlayerHead(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRendererIn) {
        super(entityRendererIn);
        int i;
        for (i = 0; i < this.eyeOverlays.length; ++i) {
            this.eyeOverlays[i] = new ResourceLocation("vampirism:textures/entity/vanilla/eyes" + i + ".png");
        }
        this.fangOverlays = new ResourceLocation[7];
        for (i = 0; i < this.fangOverlays.length; ++i) {
            this.fangOverlays[i] = new ResourceLocation("vampirism:textures/entity/vanilla/fangs" + i + ".png");
        }
    }

    public void render(AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!((Boolean)VampirismConfig.CLIENT.renderVampireEyes.get()).booleanValue() || !player.func_70089_S()) {
            return;
        }
        VampirePlayer vampirePlayer = VampirePlayer.get((PlayerEntity)player);
        if (vampirePlayer.getLevel() > 0 && !vampirePlayer.isDisguised() && !player.func_82150_aj()) {
            int eyeType = Math.max(0, Math.min(vampirePlayer.getEyeType(), this.eyeOverlays.length - 1));
            int fangType = Math.max(0, Math.min(vampirePlayer.getFangType(), this.fangOverlays.length - 1));
            GlStateManager.pushMatrix();
            if (player.func_70093_af()) {
                GlStateManager.translatef((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.func_215333_a(this.fangOverlays[fangType]);
            ((PlayerModel)this.func_215332_c()).field_78116_c.func_78785_a(scale);
            if (vampirePlayer.getGlowingEyes()) {
                this.func_215333_a(this.eyeOverlays[eyeType]);
                RenderUtil.renderGlowing(((PlayerModel)this.func_215332_c()).field_78116_c, 240.0f, player, scale);
            } else {
                this.renderNormalEyes(eyeType, scale);
            }
            GlStateManager.popMatrix();
        }
    }

    public boolean func_177142_b() {
        return true;
    }

    private void renderNormalEyes(int eyeType, float scale) {
        this.func_215333_a(this.eyeOverlays[eyeType]);
        ((PlayerModel)this.func_215332_c()).field_78116_c.func_78785_a(scale);
    }
}

