/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.tiles;

import com.mojang.blaze3d.platform.GlStateManager;
import de.teamlapen.vampirism.client.render.tiles.VampirismTESR;
import de.teamlapen.vampirism.tileentity.AltarInfusionTileEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AltarInfusionTESR
extends VampirismTESR<AltarInfusionTileEntity> {
    private final ResourceLocation enderDragonCrystalBeamTextures = new ResourceLocation("textures/entity/end_crystal/end_crystal_beam.png");
    private final ResourceLocation beaconBeamTexture = new ResourceLocation("textures/entity/beacon_beam.png");

    public void render(AltarInfusionTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        AltarInfusionTileEntity.PHASE phase = te.getCurrentPhase();
        if (phase == AltarInfusionTileEntity.PHASE.BEAM1 || phase == AltarInfusionTileEntity.PHASE.BEAM2) {
            PlayerEntity p;
            BlockPos[] tips;
            x += 0.5;
            y += 3.0;
            z += 0.5;
            double cX = (double)te.func_174877_v().func_177958_n() + 0.5;
            double cY = te.func_174877_v().func_177956_o() + 3;
            double cZ = (double)te.func_174877_v().func_177952_p() + 0.5;
            for (BlockPos tip : tips = te.getTips()) {
                this.renderBeam(x, y, z, cX, cY, cZ, (double)tip.func_177958_n() + 0.5, (double)tip.func_177956_o() + 0.5, (double)tip.func_177952_p() + 0.5, (float)te.getRunningTick() + partialTicks, false);
            }
            if (phase == AltarInfusionTileEntity.PHASE.BEAM2 && (p = te.getPlayer()) != null) {
                this.renderBeam(x, y, z, cX, cY, cZ, p.field_70165_t, p.field_70163_u + 1.2, p.field_70161_v, -((float)te.getRunningTick() + partialTicks), true);
            }
        }
    }

    private void renderBeam(double relX, double relY, double relZ, double centerX, double centerY, double centerZ, double targetX, double targetY, double targetZ, float tickStuff, boolean beacon) {
        float f2 = 50000.0f;
        float f3 = MathHelper.func_76126_a((float)(f2 * 0.2f)) / 2.0f + 0.5f;
        f3 = (f3 * f3 + f3) * 0.2f;
        float wayX = (float)(targetX - centerX);
        float wayY = (float)(targetY - centerY);
        float wayZ = (float)(targetZ - centerZ);
        float distFlat = MathHelper.func_76129_c((float)(wayX * wayX + wayZ * wayZ));
        float dist = MathHelper.func_76129_c((float)(wayX * wayX + wayY * wayY + wayZ * wayZ));
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)relX, (double)relY, (double)relZ);
        GlStateManager.rotatef((float)((float)(-Math.atan2(wayZ, wayX)) * 180.0f / (float)Math.PI - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)((float)(-Math.atan2(distFlat, wayY)) * 180.0f / (float)Math.PI - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.func_74518_a();
        GlStateManager.disableCull();
        if (beacon) {
            this.func_147499_a(this.beaconBeamTexture);
        } else {
            this.func_147499_a(this.enderDragonCrystalBeamTextures);
        }
        GlStateManager.shadeModel((int)7425);
        float f9 = -(tickStuff * 0.005f);
        float f10 = MathHelper.func_76129_c((float)(wayX * wayX + wayY * wayY + wayZ * wayZ)) / 32.0f + f9;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
        int b0 = 8;
        for (int i = 0; i <= b0; ++i) {
            float f11 = 0.2f * (MathHelper.func_76126_a((float)((float)(i % b0) * (float)Math.PI * 2.0f / (float)b0)) * 0.75f);
            float f12 = 0.2f * (MathHelper.func_76134_b((float)((float)(i % b0) * (float)Math.PI * 2.0f / (float)b0)) * 0.75f);
            float f13 = (float)(i % b0) * 1.0f / (float)b0;
            worldRenderer.func_181662_b((double)f11, (double)f12, 0.0).func_187315_a((double)f13, (double)f10).func_181669_b(255, 0, 0, 255).func_181675_d();
            if (beacon) {
                worldRenderer.func_181662_b((double)f11, (double)f12, (double)dist).func_187315_a((double)f13, (double)f9).func_181669_b(255, 0, 0, 255).func_181675_d();
                continue;
            }
            worldRenderer.func_181662_b((double)f11, (double)f12, (double)dist).func_187315_a((double)f13, (double)f9).func_181669_b(255, 255, 255, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.enableCull();
        RenderHelper.func_74519_b();
        GlStateManager.popMatrix();
    }
}

