/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.tiles;

import com.mojang.blaze3d.platform.GlStateManager;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.client.model.CoffinModel;
import de.teamlapen.vampirism.client.render.tiles.VampirismTESR;
import de.teamlapen.vampirism.tileentity.CoffinTileEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class CoffinTESR
extends VampirismTESR<CoffinTileEntity> {
    private final int maxLidPos = 61;
    private final CoffinModel model;
    private final ResourceLocation[] textures = new ResourceLocation[DyeColor.values().length];
    private Logger LOGGER = LogManager.getLogger();

    public CoffinTESR() {
        this.model = new CoffinModel();
        for (DyeColor e : DyeColor.values()) {
            this.textures[e.func_196059_a()] = new ResourceLocation("vampirism", "textures/block/coffin/coffin_" + e.func_176610_l() + ".png");
        }
    }

    public void render(CoffinTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        CoffinTileEntity tile = te;
        if (!tile.renderAsItem) {
            boolean occupied;
            if (!this.isHeadSafe(te.func_145831_w(), te.func_174877_v())) {
                return;
            }
            boolean bl = occupied = tile.renderAsItem || CoffinBlock.isOccupied((IBlockReader)te.func_145831_w(), te.func_174877_v());
            if (!occupied && tile.lidPos > 0) {
                --tile.lidPos;
            } else if (occupied && tile.lidPos < 61) {
                ++tile.lidPos;
            }
        } else {
            tile.lidPos = 61;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        int color = Math.min(tile.color.func_196059_a(), 15);
        this.func_147499_a(this.textures[color]);
        GlStateManager.pushMatrix();
        this.adjustRotatePivotViaState(te);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.rotateLid(this.calcLidAngle(tile.lidPos));
        this.model.render(0.0625f);
        GlStateManager.popMatrix();
        GlStateManager.popMatrix();
    }

    private float calcLidAngle(int pos) {
        if (pos == 61) {
            return 0.0f;
        }
        if (pos == 0) {
            return 2.3561945f;
        }
        return (float)(-Math.pow(1.02, pos) + 1.0 + 2.356194490192345);
    }

    private boolean isHeadSafe(World world, BlockPos pos) {
        try {
            return CoffinBlock.isHead((IBlockReader)world, pos);
        }
        catch (IllegalArgumentException e) {
            this.LOGGER.error("CoffinTESR", (Object)"Failed to check coffin head at %s caused by wrong blockstate. Block at that pos: %s", (Object)pos, (Object)world.func_180495_p(pos));
        }
        catch (Exception e) {
            this.LOGGER.error("CoffinTESR", (Object)e, (Object)"Failed to check coffin head at %s.", (Object)pos);
        }
        return false;
    }
}

