/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class BalanceConfig {
    public final ForgeConfigSpec.IntValue hunterTentDistance;
    public final ForgeConfigSpec.IntValue hunterTentSeparation;
    public final ForgeConfigSpec.IntValue vampireForestWeight;
    public final ForgeConfigSpec.BooleanValue canCancelSanguinare;
    public final ForgeConfigSpec.IntValue arrowVampireKillerMaxHealth;
    public final ForgeConfigSpec.IntValue holyWaterSplashDamage;
    public final ForgeConfigSpec.IntValue holyWaterNauseaDuration;
    public final ForgeConfigSpec.IntValue holyWaterBlindnessDuration;
    public final ForgeConfigSpec.IntValue dropOrchidFromLeavesChance;
    public final ForgeConfigSpec.DoubleValue holyWaterTierDamageInc;
    public final ForgeConfigSpec.DoubleValue heartSeekerChargingFactor;
    public final ForgeConfigSpec.DoubleValue heartSeekerUsageFactor;
    public final ForgeConfigSpec.BooleanValue golemAttackVampire;
    public final ForgeConfigSpec.BooleanValue zombieIgnoreVampire;
    public final ForgeConfigSpec.IntValue hunterTentMaxSpawn;
    public final ForgeConfigSpec.DoubleValue crossbowDamageMult;
    public final ForgeConfigSpec.IntValue vampireDungeonWeight;
    public final ForgeConfigSpec.DoubleValue eaHealthThreshold;
    public final ForgeConfigSpec.IntValue eaInvisibilityCooldown;
    public final ForgeConfigSpec.IntValue eaInvisibilityDuration;
    public final ForgeConfigSpec.IntValue eaHealCooldown;
    public final ForgeConfigSpec.IntValue eaHealAmount;
    public final ForgeConfigSpec.IntValue eaRegenerationDuration;
    public final ForgeConfigSpec.IntValue eaRegenerationCooldown;
    public final ForgeConfigSpec.IntValue eaRegenerationAmount;
    public final ForgeConfigSpec.IntValue eaSpeedDuration;
    public final ForgeConfigSpec.IntValue eaSpeedCooldown;
    public final ForgeConfigSpec.DoubleValue eaSpeedAmount;
    public final ForgeConfigSpec.IntValue eaBatspawnCooldown;
    public final ForgeConfigSpec.IntValue eaBatspawnAmount;
    public final ForgeConfigSpec.IntValue eaDarkProjectileCooldown;
    public final ForgeConfigSpec.DoubleValue eaDarkProjectileDamage;
    public final ForgeConfigSpec.DoubleValue eaDarkProjectileIndirectDamage;
    public final ForgeConfigSpec.IntValue eaSunscreenDuration;
    public final ForgeConfigSpec.IntValue eaSunscreenCooldown;
    public final ForgeConfigSpec.IntValue eaIgnoreSundamageDuration;
    public final ForgeConfigSpec.IntValue eaIgnoreSundamageCooldown;
    public final ForgeConfigSpec.IntValue eaGarlicDuration;
    public final ForgeConfigSpec.IntValue eaGarlicCooldown;
    public final ForgeConfigSpec.DoubleValue haDisguiseVisibilityMod;
    public final ForgeConfigSpec.BooleanValue haDisguiseEnabled;
    public final ForgeConfigSpec.IntValue haDisguiseInvisibleSQ;
    public final ForgeConfigSpec.IntValue haAwarenessDuration;
    public final ForgeConfigSpec.IntValue haAwarenessCooldown;
    public final ForgeConfigSpec.BooleanValue haAwarenessEnabled;
    public final ForgeConfigSpec.IntValue haAwarenessRadius;
    public final ForgeConfigSpec.DoubleValue hpStrengthMaxMod;
    public final ForgeConfigSpec.DoubleValue hpStrengthType;
    public final ForgeConfigSpec.DoubleValue hsSmallAttackSpeedModifier;
    public final ForgeConfigSpec.DoubleValue hsMajorAttackSpeedModifier;
    public final ForgeConfigSpec.BooleanValue hsInstantKill1FromBehind;
    public final ForgeConfigSpec.DoubleValue hsInstantKill1MaxHealth;
    public final ForgeConfigSpec.IntValue hsInstantKill2MaxHealth;
    public final ForgeConfigSpec.BooleanValue hsInstantKill2OnlyNPC;
    public final ForgeConfigSpec.IntValue hsGarlicDiffusorNormalDist;
    public final ForgeConfigSpec.IntValue hsGarlicDiffusorEnhancedDist;
    public final ForgeConfigSpec.IntValue hsGarlicDiffusorWeakDist;
    public final ForgeConfigSpec.BooleanValue viReplaceBlocks;
    public final ForgeConfigSpec.IntValue viPhase1Duration;
    public final ForgeConfigSpec.IntValue viNotifyDistanceSQ;
    public final ForgeConfigSpec.IntValue viForceTargetTime;
    public final ForgeConfigSpec.IntValue viHunterTrainerWeight;
    public final ForgeConfigSpec.IntValue viTotemWeight;
    public final ForgeConfigSpec.DoubleValue viTotemPreSetPercentage;
    public final ForgeConfigSpec.IntValue viMaxVillagerRespawn;
    public final ForgeConfigSpec.DoubleValue vsSundamgeReduction1;
    public final ForgeConfigSpec.DoubleValue vsThirstReduction1;
    public final ForgeConfigSpec.DoubleValue vsBiteDamageMult;
    public final ForgeConfigSpec.DoubleValue vsSwordFinisherMaxHealth;
    public final ForgeConfigSpec.IntValue vsJumpBoost;
    public final ForgeConfigSpec.DoubleValue vsSpeedBoost;
    public final ForgeConfigSpec.IntValue vsBloodVisionDistSQ;
    public final ForgeConfigSpec.BooleanValue vsDisableAvoidedByCreepers;
    public final ForgeConfigSpec.DoubleValue vpHealthMaxMod;
    public final ForgeConfigSpec.DoubleValue vpStrengthMaxMod;
    public final ForgeConfigSpec.DoubleValue vpSpeedMaxMod;
    public final ForgeConfigSpec.DoubleValue vpExhaustionMaxMod;
    public final ForgeConfigSpec.DoubleValue vpBasicBloodExhaustionMod;
    public final ForgeConfigSpec.BooleanValue vpBloodUsagePeaceful;
    public final ForgeConfigSpec.IntValue vpBiteDamage;
    public final ForgeConfigSpec.DoubleValue vpPlayerBloodSaturation;
    public final ForgeConfigSpec.IntValue vpSanguinareAverageDuration;
    public final ForgeConfigSpec.IntValue vpSundamageMinLevel;
    public final ForgeConfigSpec.BooleanValue vpSundamageNausea;
    public final ForgeConfigSpec.IntValue vpSundamageNauseaMinLevel;
    public final ForgeConfigSpec.IntValue vpSundamageWeaknessMinLevel;
    public final ForgeConfigSpec.DoubleValue vpSundamage;
    public final ForgeConfigSpec.IntValue vpSundamageWaterBlocks;
    public final ForgeConfigSpec.DoubleValue vpFireVulnerabilityMaxMod;
    public final ForgeConfigSpec.IntValue vaFreezeCooldown;
    public final ForgeConfigSpec.BooleanValue vaFreezeEnabled;
    public final ForgeConfigSpec.IntValue vaFreezeDuration;
    public final ForgeConfigSpec.IntValue vaInvisibilityDuration;
    public final ForgeConfigSpec.IntValue vaInvisibilityCooldown;
    public final ForgeConfigSpec.BooleanValue vaInvisibilityEnabled;
    public final ForgeConfigSpec.IntValue vaRegenerationCooldown;
    public final ForgeConfigSpec.IntValue vaRegenerationDuration;
    public final ForgeConfigSpec.BooleanValue vaRegenerationEnabled;
    public final ForgeConfigSpec.IntValue vaTeleportMaxDistance;
    public final ForgeConfigSpec.IntValue vaTeleportCooldown;
    public final ForgeConfigSpec.BooleanValue vaTeleportEnabled;
    public final ForgeConfigSpec.IntValue vaRageCooldown;
    public final ForgeConfigSpec.IntValue vaRageMinDuration;
    public final ForgeConfigSpec.IntValue vaRageDurationIncrease;
    public final ForgeConfigSpec.BooleanValue vaRageEnabled;
    public final ForgeConfigSpec.IntValue vaSunscreenCooldown;
    public final ForgeConfigSpec.IntValue vaSunscreenDuration;
    public final ForgeConfigSpec.BooleanValue vaSunscreenEnabled;
    public final ForgeConfigSpec.IntValue vaBatCooldown;
    public final ForgeConfigSpec.IntValue vaBatDuration;
    public final ForgeConfigSpec.BooleanValue vaBatEnabled;
    public final ForgeConfigSpec.DoubleValue vaBatHealthReduction;
    public final ForgeConfigSpec.BooleanValue vaSummonBatEnabled;
    public final ForgeConfigSpec.IntValue vaSummonBatCooldown;
    public final ForgeConfigSpec.IntValue vaSummonBatCount;
    public final ForgeConfigSpec.IntValue vaDisguiseDuration;
    public final ForgeConfigSpec.IntValue vaDisguiseCooldown;
    public final ForgeConfigSpec.BooleanValue vaDisguiseEnabled;
    public final ForgeConfigSpec.IntValue vaDarkBloodCooldown;
    public final ForgeConfigSpec.BooleanValue vaDarkBloodEnabled;
    public final ForgeConfigSpec.DoubleValue vaDarkBloodDamage;
    public final ForgeConfigSpec.IntValue vaHalfInvulnerableCooldown;
    public final ForgeConfigSpec.IntValue vaHalfInvulnerableDuration;
    public final ForgeConfigSpec.IntValue vaHalfInvulnerableBloodCost;
    public final ForgeConfigSpec.DoubleValue vaHalfInvulnerableThreshold;
    public final ForgeConfigSpec.BooleanValue vaHalfInvulnerableEnabled;

    BalanceConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("A ton of options which allow you to balance the mod to your desire");
        builder.push("balance");
        builder.comment("General options");
        builder.push("general");
        this.hunterTentDistance = builder.comment("dont set hunterTentDistance <= hunterTentSeperation").defineInRange("hunterTentDistance", 8, 2, Integer.MAX_VALUE);
        this.hunterTentSeparation = builder.comment("dont set hunterTentDistance <= hunterTentSeperation").defineInRange("hunterTentSeperation", 3, 1, Integer.MAX_VALUE);
        this.vampireForestWeight = builder.defineInRange("vampireForestWeight", 6, 1, Integer.MAX_VALUE);
        this.canCancelSanguinare = builder.comment("If the sanguinare effect can be canceled by milk").define("canCancelSanguinare", true);
        this.arrowVampireKillerMaxHealth = builder.comment("The vampire killer arrow can only instant kill NPC vampires that have a max (not actual) health of this").defineInRange("arrowVampireKillerMaxHealth", 40, 1, Integer.MAX_VALUE);
        this.holyWaterSplashDamage = builder.comment("Damage a normal holy water splash bottle does when directly hitting a vampire").defineInRange("holyWaterSplashDamage", 5, 0, Integer.MAX_VALUE);
        this.holyWaterTierDamageInc = builder.comment("Holy water damage is multiplied with this value for each tier above normal").defineInRange("holyWaterTierDamageInc", 2.0, 1.0, 10.0);
        this.holyWaterNauseaDuration = builder.comment("Duration of the nausea effect caused by enhanced or special holy water (ticks)").defineInRange("holyWaterNauseaDuration", 200, 0, 1000);
        this.holyWaterBlindnessDuration = builder.comment("Duration of the blindness effect caused by special holy water (ticks)").defineInRange("holyWaterBlindnessDuration", 160, 0, 1000);
        this.heartSeekerChargingFactor = builder.comment("The blood mB to charge percentage of the normal heart seeker vampire sword").defineInRange("heartSeekerChargingFactor", 5.0E-4, 0.0, 1.0);
        this.heartSeekerUsageFactor = builder.comment("The percentage of stored blood used for every hit with the normal heart seeker vampire sword").defineInRange("heartSeekerUsageFactor", 0.5, 0.0, 100.0);
        this.dropOrchidFromLeavesChance = builder.comment("Drop orchid every n times breaking a leave in the vampire forest").defineInRange("dropOrchidFromLeavesChance", 25, 1, Integer.MAX_VALUE);
        this.golemAttackVampire = builder.comment("If iron golems should attack vampire NPCs if in a non-vampire village").define("golemAttackVampire", true);
        this.zombieIgnoreVampire = builder.comment("If zombies should ignore vampires").define("zombieIgnoreVampire", true);
        this.hunterTentMaxSpawn = builder.comment("Maximum number of hunters that can spawn at one tent per day").defineInRange("hunterTentMaxSpawn", 4, 0, 20);
        this.crossbowDamageMult = builder.comment("The base damage dealt by crossbow arrows is multiplied by this").defineInRange("crossbowDamageMult", 1.0, 0.2, 5.0);
        this.vampireDungeonWeight = builder.comment("Weight of the dungeon room. Vanilla is 8").defineInRange("vampireDungeonWeight", 2, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("entityActions");
        this.eaHealthThreshold = builder.comment("Relative health a entity must have to use actions").defineInRange("healthThreshold", 0.3, 0.0, 1.0);
        this.eaInvisibilityCooldown = builder.comment("In seconds").defineInRange("invisibilityCooldown", 7, 1, Integer.MAX_VALUE);
        this.eaInvisibilityDuration = builder.comment("In seconds").defineInRange("invisibilityDuration", 4, 1, Integer.MAX_VALUE);
        this.eaHealAmount = builder.comment("In percent").defineInRange("healAmount", 30, 0, 100);
        this.eaHealCooldown = builder.comment("In seconds").defineInRange("healCooldown", 7, 1, Integer.MAX_VALUE);
        this.eaRegenerationDuration = builder.comment("In seconds").defineInRange("regenerationDuration", 5, 0, Integer.MAX_VALUE);
        this.eaRegenerationAmount = builder.comment("In percent").defineInRange("regenerationAmount", 40, 0, 100);
        this.eaRegenerationCooldown = builder.comment("In seconds").defineInRange("regenerationCooldown", 8, 0, Integer.MAX_VALUE);
        this.eaSpeedDuration = builder.comment("In seconds").defineInRange("speedDuration", 4, 0, Integer.MAX_VALUE);
        this.eaSpeedCooldown = builder.comment("In seconds").defineInRange("speedCooldonw", 6, 1, Integer.MAX_VALUE);
        this.eaSpeedAmount = builder.comment("Speed = basevalue * (1+ speedAmount)").defineInRange("speedAmount", 0.14, 0.0, 2.0);
        this.eaBatspawnAmount = builder.defineInRange("batspawnAmount", 4, 1, 10);
        this.eaBatspawnCooldown = builder.comment("In seconds").defineInRange("batspawnCooldown", 15, 1, Integer.MAX_VALUE);
        this.eaDarkProjectileCooldown = builder.comment("In seconds").defineInRange("darkProjectileCooldown", 10, 1, Integer.MAX_VALUE);
        this.eaDarkProjectileDamage = builder.defineInRange("darkProjectileDamage", 5.0, 0.0, 100.0);
        this.eaDarkProjectileIndirectDamage = builder.defineInRange("darkProjectileIndirectDamage", 2.0, 0.0, 100.0);
        this.eaSunscreenDuration = builder.comment("In seconds").defineInRange("sunscreenDuration", 9, 0, Integer.MAX_VALUE);
        this.eaSunscreenCooldown = builder.comment("In seconds").defineInRange("sunscreenCooldown", 10, 1, Integer.MAX_VALUE);
        this.eaIgnoreSundamageCooldown = builder.comment("In seconds").defineInRange("ignoreSundamageCooldown", 6, 1, Integer.MAX_VALUE);
        this.eaIgnoreSundamageDuration = builder.comment("In seconds").defineInRange("ignoreSundamageDuration", 5, 0, Integer.MAX_VALUE);
        this.eaGarlicCooldown = builder.comment("In seconds").defineInRange("garlicCooldown", 5, 1, Integer.MAX_VALUE);
        this.eaGarlicDuration = builder.comment("In seconds").defineInRange("garlicDuration", 5, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("hunterActions");
        this.haDisguiseEnabled = builder.define("disguiseEnabled", true);
        this.haDisguiseVisibilityMod = builder.comment("If disguised the detection radius of mobs will be multiplied by this").defineInRange("disguiseInvisibilityMod", 0.1, 0.0, 1.0);
        this.haDisguiseInvisibleSQ = builder.comment("Squared distance as of which a disguised hunter is invisible").defineInRange("disguiseInvisibileSQ", 256, 1, Integer.MAX_VALUE);
        this.haAwarenessEnabled = builder.define("awarenessEnabled", true);
        this.haAwarenessDuration = builder.comment("In ticks").defineInRange("awarenessDuration", 2400, 1, Integer.MAX_VALUE);
        this.haAwarenessCooldown = builder.comment("In ticks").defineInRange("awarenessCooldown", 1200, 1, Integer.MAX_VALUE);
        this.haAwarenessRadius = builder.comment("Radius in which vampires should be detected").defineInRange("awarenessRadius", 24, 0, 50);
        builder.pop();
        builder.push("hunterPlayer");
        this.hpStrengthMaxMod = builder.comment("Stringth = Old * (modifier+1").defineInRange("strengthMaxMod", 2.0, 0.5, 4.0);
        this.hpStrengthType = builder.comment("0.5 for square root, 1 for linear").defineInRange("strengthType", 0.5, 0.5, 1.0);
        builder.pop();
        builder.push("hunterSkills");
        this.hsSmallAttackSpeedModifier = builder.comment("Basic skill - Weapon cooldown = 1/(oldvalue*(1+modifier))").defineInRange("smallAttackSpeedModifier", 0.2, 0.0, 3.0);
        this.hsMajorAttackSpeedModifier = builder.comment("Advanced skill - Weapon cooldown = 1/(oldvalue*(1+modifier)").defineInRange("majorAttackSpeedModifier", 0.4, 0.0, 3.0);
        this.hsInstantKill1FromBehind = builder.comment("First stake skill - If it is required to attack from behind to instant kill low level vampires").define("instantKill1FromBehind", false);
        this.hsInstantKill1MaxHealth = builder.comment("First stake skill -The maximal relative health a entity may have to be instantly killed").defineInRange("instantKill1MaxHealth", 0.35, 0.0, 1.0);
        this.hsInstantKill2MaxHealth = builder.comment("Second stake skill - The max (not the actual) health of an entity that can be one hit killed from behind").defineInRange("instantKill2MaxHealth", 200, 0, Integer.MAX_VALUE);
        this.hsInstantKill2OnlyNPC = builder.comment("Second stake skill - Whether only NPCs can be one hit killed with this skill").define("instantKill2OnlyNPC", false);
        this.hsGarlicDiffusorNormalDist = builder.comment("The chunk radius a normal diffusor affects. 0 results in a one chunk area. Changing this only affects newly placed blocks").defineInRange("garlicDiffusorNormalDist", 0, 0, 5);
        this.hsGarlicDiffusorEnhancedDist = builder.comment("The chunk radius a enhanced diffusor affects. 0 results in a one chunk area. Changing this only affects newly placed blocks").defineInRange("garlicDiffusorEnhancedDist", 1, 0, 5);
        this.hsGarlicDiffusorWeakDist = builder.comment("The chunk radius a normal diffusor affects. 0 results in a one chunk area. Changing this only affects newly placed blocks").defineInRange("garlicDiffusorWeakDist", 2, 0, 5);
        builder.pop();
        builder.push("village");
        this.viReplaceBlocks = builder.comment("Whether grass should slowly be replaced with cursed earth in vampire villages").define("replaceBlocks", true);
        this.viPhase1Duration = builder.comment("Duration of phase 1 of the capturing process in 2*seconds").defineInRange("phase1Duration", 80, 1, 1000);
        this.viNotifyDistanceSQ = builder.comment("Squared distance of village capture notification").defineInRange("notifyDistanceSQ", 40000, 0, 100000);
        this.viForceTargetTime = builder.comment("Time in 2*seconds in capture phase 2 after which the capture entities should find a target regardless of distance").defineInRange("forceTargetTime", 80, 1, 1000);
        this.viHunterTrainerWeight = builder.comment("Weight of the Hunter Trainer Building inside the village").defineInRange("viHunterTrainerWeight", 400, 1, Integer.MAX_VALUE);
        this.viTotemWeight = builder.comment("Weight of the Totem Building inside the Village").defineInRange("viTotemWeight", 20, 1, Integer.MAX_VALUE);
        this.viTotemPreSetPercentage = builder.comment("Percentage of totem which should be have a pre defined faction").defineInRange("viTotemPreSetPercentage", 0.6, 0.0, 1.0);
        this.viMaxVillagerRespawn = builder.comment("Maximum of Villager the Totem can respawn").defineInRange("viMaxVillagerRespawn", 30, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("vampireSkills");
        this.vsSundamgeReduction1 = builder.comment("Sundamage is multipled with (value+1)").defineInRange("sundamageReduction1", -0.3, -1.0, 0.0);
        this.vsThirstReduction1 = builder.comment("Blood exhaustion is multiplied with (value+1)").defineInRange("bloodThirstReduction1", -0.4, -1.0, 0.0);
        this.vsBiteDamageMult = builder.comment("Bite damage is multiplied with (value+1)").defineInRange("biteDamageMult", 1.0, 0.0, 100.0);
        this.vsSwordFinisherMaxHealth = builder.comment("The max relative health for sword finisher kill").defineInRange("swordFinisherMaxHealth", 0.25, 0.0, 1.0);
        this.vsJumpBoost = builder.comment("Similar to potion effect ampliofier (and -1 is normal)").defineInRange("jumpBoost", 1, -1, 5);
        this.vsSpeedBoost = builder.comment("Max speed is multiplied with (value+1)").defineInRange("speedBoost", 0.15, 0.0, 3.0);
        this.vsBloodVisionDistSQ = builder.comment("Squared blood vision distance").defineInRange("bloodVisionDistanceSq", 1600, 5, Integer.MAX_VALUE);
        this.vsDisableAvoidedByCreepers = builder.comment("Disables the effect of 'Avoided by creepers'. Can still be unlocked though.").define("disableAvoidedByCreepers", false);
        builder.pop();
        builder.push("vampirePlayer");
        this.vpHealthMaxMod = builder.defineInRange("healthMaxMod", 16.0, 0.5, 40.0);
        this.vpStrengthMaxMod = builder.defineInRange("strengthMaxMod", 1.0, 0.5, 2.0);
        this.vpSpeedMaxMod = builder.defineInRange("speedMaxMod", 0.3, 0.0, 5.0);
        this.vpExhaustionMaxMod = builder.defineInRange("exhaustionMaxMod", 1.0, 0.0, 10.0);
        this.vpBasicBloodExhaustionMod = builder.comment("Blood exhaustion is multiplied with this value").defineInRange("basicBloodExhaustionMod", 0.7, 0.0, 5.0);
        this.vpBloodUsagePeaceful = builder.comment("Whether blood is consumed in peaceful gamemode").define("bloodUsagePeaceful", false);
        this.vpBiteDamage = builder.defineInRange("biteDamage", 4, 0, Integer.MAX_VALUE);
        this.vpPlayerBloodSaturation = builder.defineInRange("playerBloodSaturation", 1.5, 0.3, 10.0);
        this.vpSanguinareAverageDuration = builder.defineInRange("sanguinareAverageDuration", 900, 1, 10000);
        this.vpSundamage = builder.defineInRange("sundamage", 7.0, 1.0, Double.MAX_VALUE);
        this.vpSundamageMinLevel = builder.defineInRange("sundamageMinLevel", 4, 1, Integer.MAX_VALUE);
        this.vpSundamageNausea = builder.define("sundamageNausea", true);
        this.vpSundamageNauseaMinLevel = builder.defineInRange("sundamageNauseaMinLevel", 3, 1, Integer.MAX_VALUE);
        this.vpSundamageWeaknessMinLevel = builder.defineInRange("sundamageWeaknessMinLevel", 2, 1, Integer.MAX_VALUE);
        this.vpSundamageWaterBlocks = builder.defineInRange("sundamageWaterblocks", 4, 1, 10);
        this.vpFireVulnerabilityMaxMod = builder.defineInRange("fireVulnerabilityMod", 4.0, 0.1, Double.MAX_VALUE);
        builder.pop();
        builder.push("vampireActions");
        this.vaFreezeCooldown = builder.comment("In seconds").defineInRange("freezeCooldown", 60, 1, Integer.MAX_VALUE);
        this.vaFreezeDuration = builder.comment("In seconds").defineInRange("freezeDuration", 6, 1, 30);
        this.vaFreezeEnabled = builder.define("freezeEnabled", true);
        this.vaInvisibilityCooldown = builder.comment("In seconds").defineInRange("invisibilityCooldown", 25, 1, Integer.MAX_VALUE);
        this.vaInvisibilityDuration = builder.comment("In seconds").defineInRange("invisibilityDuration", 25, 1, Integer.MAX_VALUE);
        this.vaInvisibilityEnabled = builder.define("invisibilityEnabled", true);
        this.vaRegenerationCooldown = builder.comment("In seconds").defineInRange("regenerationCooldown", 60, 0, Integer.MAX_VALUE);
        this.vaRegenerationDuration = builder.comment("In seconds").defineInRange("regenerationDuration", 20, 0, Integer.MAX_VALUE);
        this.vaRegenerationEnabled = builder.define("regenerationEnabled", true);
        this.vaTeleportCooldown = builder.comment("In seconds").defineInRange("teleportCooldown", 10, 1, Integer.MAX_VALUE);
        this.vaTeleportMaxDistance = builder.defineInRange("teleportMaxDistance", 50, 1, 1000);
        this.vaTeleportEnabled = builder.define("teleportEnabled", true);
        this.vaRageCooldown = builder.comment("In seconds").defineInRange("rageCooldown", 20, 0, Integer.MAX_VALUE);
        this.vaRageMinDuration = builder.comment("In seconds").defineInRange("rageMinDuration", 13, 1, 10000);
        this.vaRageDurationIncrease = builder.comment("In seconds. Increase per vampire level").defineInRange("rageDurationIncrease", 5, 0, 1000);
        this.vaRageEnabled = builder.define("rageEnabled", true);
        this.vaSunscreenCooldown = builder.comment("In seconds").defineInRange("sunscreenCooldown", 500, 0, 1000);
        this.vaSunscreenDuration = builder.comment("In seconds").defineInRange("sunscreenDuration", 40, 1, Integer.MAX_VALUE);
        this.vaSunscreenEnabled = builder.define("sunscreenEnabled", true);
        this.vaBatEnabled = builder.define("batEnabled", true);
        this.vaBatCooldown = builder.comment("In seconds").defineInRange("batCooldown", 0, 0, 10000);
        this.vaBatDuration = builder.comment("In seconds").defineInRange("batDuration", Integer.MAX_VALUE, 10, Integer.MAX_VALUE);
        this.vaBatHealthReduction = builder.comment("The player health will be reduced by this factor").defineInRange("batHealthReduction", 0.9, 0.0, 0.95);
        this.vaSummonBatCooldown = builder.comment("In seconds").defineInRange("summonBatsCooldown", 300, 1, 10000);
        this.vaSummonBatCount = builder.defineInRange("summonBatsCount", 16, 1, 100);
        this.vaSummonBatEnabled = builder.define("summonBatEnabled", true);
        this.vaDisguiseCooldown = builder.comment("In seconds").defineInRange("disguiseCooldown", 60, 1, 10000);
        this.vaDisguiseDuration = builder.comment("In seconds").defineInRange("disguiseDuration", 60, 1, 10000);
        this.vaDisguiseEnabled = builder.define("disguiseEnabled", true);
        this.vaDarkBloodCooldown = builder.comment("In seconds").defineInRange("darkBloodProjectileCooldown", 4, 1, 1000);
        this.vaDarkBloodDamage = builder.defineInRange("darkBloodProjectileDamage", 6.0, 0.0, 10000.0);
        this.vaDarkBloodEnabled = builder.define("darkBloodProjectileEnabled", true);
        this.vaHalfInvulnerableCooldown = builder.defineInRange("halfInvulnerableCooldown", 60, 1, 10000);
        this.vaHalfInvulnerableDuration = builder.defineInRange("halfInvulnerableDuration", 30, 1, 10000);
        this.vaHalfInvulnerableThreshold = builder.comment("Damage threshold relative to players max health. Damage above this value will be ignored").defineInRange("halfInvulnerableThreshold", 0.4, 0.0, 1.0);
        this.vaHalfInvulnerableBloodCost = builder.defineInRange("halfInvulnerableBloodCost", 4, 0, 1000);
        this.vaHalfInvulnerableEnabled = builder.define("halfInvulnerableEnabled", true);
        builder.pop();
        builder.pop();
    }
}

