/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModWorld;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.modcompat.IntegrationsNotifier;
import de.teamlapen.vampirism.network.BloodValuePacket;
import de.teamlapen.vampirism.network.SkillTreePacket;
import de.teamlapen.vampirism.tileentity.TotemTileEntity;
import java.lang.reflect.Array;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.OverworldChunkGenerator;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(ModEventHandler.class);

    @SubscribeEvent(priority=EventPriority.LOW)
    public void on(WorldEvent.Load event) {
        ChunkGenerator generator = event.getWorld().func_72863_F().func_201711_g();
        if (generator instanceof OverworldChunkGenerator) {
            GenerationSettings settings = ((OverworldChunkGenerator)generator).func_201496_a_();
            ModWorld.modifyVillageSize(settings);
        }
    }

    @SubscribeEvent
    public void onConfigurationChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equalsIgnoreCase("vampirism")) {
            LOGGER.info("Configuration ({}) changed", (Object)e.getConfigID());
        }
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        PlayerEntity p;
        if (event.getState().func_177230_c().equals(Blocks.field_196642_W) && ModBiomes.vampire_forest.equals(event.getWorld().func_180494_b(event.getPos())) && (p = event.getHarvester()) != null && p.func_70681_au().nextInt((Integer)VampirismConfig.BALANCE.dropOrchidFromLeavesChance.get()) == 0) {
            event.getDrops().add(new ItemStack((IItemProvider)ModBlocks.vampire_orchid, 1));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        boolean isAdminLikePlayer;
        VersionChecker.VersionInfo versionInfo = VampirismMod.instance.getVersionInfo();
        if (!versionInfo.isChecked()) {
            LOGGER.warn("Version check is not finished yet");
        }
        boolean bl = isAdminLikePlayer = !ServerLifecycleHooks.getCurrentServer().func_71262_S() || UtilLib.isPlayerOp(event.getPlayer());
        if (((Boolean)VampirismConfig.COMMON.versionCheck.get()).booleanValue() && versionInfo.isNewVersionAvailable() && (isAdminLikePlayer || event.getPlayer().func_70681_au().nextInt(5) == 0) && event.getPlayer().func_70681_au().nextInt(4) == 0) {
            VersionChecker.Version newVersion = versionInfo.getNewVersion();
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.outdated", new Object[]{versionInfo.getCurrentVersion().name, newVersion.name}));
            ITextComponent download = new TranslationTextComponent("text.vampirism.update_message.download", new Object[0]).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, newVersion.getUrl() == null ? versionInfo.getHomePage() : newVersion.getUrl())).func_150228_d(Boolean.valueOf(true)).func_150238_a(TextFormatting.BLUE));
            ITextComponent changelog = new TranslationTextComponent("text.vampirism.update_message.changelog", new Object[0]).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/vampirism changelog")).func_150228_d(Boolean.valueOf(true)));
            ITextComponent modpage = new TranslationTextComponent("text.vampirism.update_message.modpage", new Object[0]).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, versionInfo.getHomePage())).func_150228_d(Boolean.valueOf(true)).func_150238_a(TextFormatting.BLUE));
            event.getPlayer().func_145747_a(download.func_150258_a(" ").func_150257_a(changelog).func_150258_a(" ").func_150257_a(modpage));
        }
        if (isAdminLikePlayer) {
            List<String> mods = IntegrationsNotifier.shouldNotifyAboutIntegrations();
            if (!mods.isEmpty()) {
                event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.integrations_available.first", new Object[0]));
                event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.BLUE + TextFormatting.ITALIC.toString() + StringUtils.join(mods, (String)", ") + TextFormatting.RESET));
                event.getPlayer().func_145747_a(new TranslationTextComponent("text.vampirism.integrations_available.download", new Object[0]).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/vampirism-integrations")).func_150228_d(Boolean.valueOf(true))));
            }
            if (!ModList.get().isLoaded("guideapi-vp") && ((Boolean)VampirismConfig.SERVER.infoAboutGuideAPI.get()).booleanValue()) {
                event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.guideapi_available.first", new Object[0]));
                event.getPlayer().func_145747_a(new TranslationTextComponent("text.vampirism.guideapi_available.download", new Object[0]).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/guide-api-village-and-pillage")).func_150228_d(Boolean.valueOf(true))));
                VampirismConfig.SERVER.infoAboutGuideAPI.set((Object)false);
            }
        }
        VampirismMod.dispatcher.sendTo(new SkillTreePacket(VampirismMod.proxy.getSkillTree(false).getCopy()), (ServerPlayerEntity)event.getPlayer());
        Pair[] bloodValues = (Pair[])Array.newInstance(Pair.class, 3);
        bloodValues[0] = new Pair(((VampirismEntityRegistry)VampirismAPI.entityRegistry()).getBloodValues(), (Object)((VampirismEntityRegistry)VampirismAPI.entityRegistry()).getBloodMultiplier());
        bloodValues[1] = new Pair(BloodConversionRegistry.getItemValues(), (Object)BloodConversionRegistry.getItemMultiplier());
        bloodValues[2] = new Pair(BloodConversionRegistry.getFluidValues(), (Object)BloodConversionRegistry.getFluidDivider());
        VampirismMod.dispatcher.sendTo(new BloodValuePacket(bloodValues), (ServerPlayerEntity)event.getPlayer());
        if (!PermissionAPI.hasPermission((PlayerEntity)event.getPlayer(), (String)"vampirism.check")) {
            event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent("[" + TextFormatting.DARK_PURPLE + "Vampirism" + TextFormatting.RESET + "] It seems like the permission plugin used is not properly set up. Make sure all players have 'vampirism.*' for the mod to work (or at least '" + "vampirism.check" + "' to suppress this warning)."));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        VampirismAPI.getGarlicChunkHandler((IWorld)event.getWorld().func_201672_e()).clear();
        TotemTileEntity.clearCacheForDimension(event.getWorld().func_201675_m());
    }
}

