/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.world.loot.AddBookNbt;
import de.teamlapen.vampirism.world.loot.AdjustableLevelCondition;
import de.teamlapen.vampirism.world.loot.SetItemBloodCharge;
import de.teamlapen.vampirism.world.loot.SetMetaBasedOnLevel;
import de.teamlapen.vampirism.world.loot.StakeCondition;
import de.teamlapen.vampirism.world.loot.TentSpawnerCondition;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModLootTables {
    public static final ResourceLocation vampire = ModLootTables.register("entities/" + ModEntities.vampire.getRegistryName().func_110623_a());
    public static final ResourceLocation hunter = ModLootTables.register("entities/" + ModEntities.hunter.getRegistryName().func_110623_a());
    public static final ResourceLocation advanced_vampire = ModLootTables.register("entities/" + ModEntities.advanced_vampire.getRegistryName().func_110623_a());
    public static final ResourceLocation advanced_hunter = ModLootTables.register("entities/" + ModEntities.advanced_hunter.getRegistryName().func_110623_a());
    public static final ResourceLocation vampire_dungeon = ModLootTables.register("chests/dungeon/vampire_dungeon");
    private static final List<String> INJECTION_TABLES = ImmutableList.of((Object)"abandoned_mineshaft", (Object)"jungle_temple", (Object)"stronghold_corridor", (Object)"desert_pyramid", (Object)"stronghold_library");
    private static final List<String> STRUCTURE_TABLES = Lists.newArrayList();
    private static int injected = 0;

    static ResourceLocation register(String resourceName) {
        return LootTables.func_186375_a((ResourceLocation)new ResourceLocation("vampirism", resourceName));
    }

    static ResourceLocation register(ResourceLocation resourceLocation) {
        return LootTables.func_186375_a((ResourceLocation)resourceLocation);
    }

    static void registerLootFunctions() {
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new AddBookNbt.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new SetItemBloodCharge.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new SetMetaBasedOnLevel.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new StakeCondition.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new AdjustableLevelCondition.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new TentSpawnerCondition.Serializer());
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        String file;
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix) && INJECTION_TABLES.contains(file = name.substring(name.indexOf(prefix) + prefix.length()))) {
            event.getTable().addPool(ModLootTables.getInjectPool(file));
            ++injected;
        }
    }

    private static LootPool getInjectPool(String entryName) {
        StandaloneLootEntry.Builder entryBuilder = TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("vampirism", "inject/" + entryName)).func_216086_a(1);
        return LootPool.func_216096_a().name("vampirism_inject_pool").bonusRolls(0.0f, 1.0f).func_216046_a((IRandomRange)new RandomValueRange(1.0f)).func_216045_a((LootEntry.Builder)entryBuilder).func_216044_b();
    }

    public static boolean checkAndResetInsertedAll() {
        int i = injected;
        injected = 0;
        return i >= INJECTION_TABLES.size();
    }

    static {
        INJECTION_TABLES.forEach(table -> LootTables.func_186375_a((ResourceLocation)new ResourceLocation("vampirism", "inject/" + table)));
    }
}

