/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleData;
import de.teamlapen.vampirism.particle.FlyingBloodParticleData;
import de.teamlapen.vampirism.particle.GenericParticleData;
import java.util.Random;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="vampirism")
public class ModParticles {
    public static final ParticleType<FlyingBloodParticleData> flying_blood = (ParticleType)UtilLib.getNull();
    public static final ParticleType<FlyingBloodEntityParticleData> flying_blood_entity = (ParticleType)UtilLib.getNull();
    public static final BasicParticleType halloween = (BasicParticleType)UtilLib.getNull();
    public static final ParticleType<GenericParticleData> generic = (ParticleType)UtilLib.getNull();

    static void registerParticles(IForgeRegistry<ParticleType<?>> registry) {
        registry.register(new ParticleType(false, FlyingBloodParticleData.DESERIALIZER).setRegistryName(new ResourceLocation("vampirism", "flying_blood")));
        registry.register(new ParticleType(false, FlyingBloodEntityParticleData.DESERIALIZER).setRegistryName(new ResourceLocation("vampirism", "flying_blood_entity")));
        registry.register(new BasicParticleType(false).setRegistryName(new ResourceLocation("vampirism", "halloween")));
        registry.register(new ParticleType(false, GenericParticleData.DESERIALIZER).setRegistryName(new ResourceLocation("vampirism", "generic")));
    }

    public static void spawnParticlesClient(World worldIn, IParticleData particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int count, double maxDist, Random rand) {
        assert (!(worldIn instanceof ServerWorld)) : "Calling spawnParticlesClient on ServerWorld is pointless";
        for (int i = 0; i < count; ++i) {
            worldIn.func_195594_a(particle, x + maxDist * (2.0 * rand.nextDouble() - 1.0), y + (2.0 * rand.nextDouble() - 1.0) * maxDist, z + (2.0 * rand.nextDouble() - 1.0) * maxDist, xSpeed, ySpeed, zSpeed);
        }
    }

    public static void spawnParticlesClient(World worldIn, IParticleData particle, double x, double y, double z, int count, double maxDist, Random rand) {
        ModParticles.spawnParticlesClient(worldIn, particle, x, y, z, 0.0, 0.0, 0.0, count, maxDist, rand);
    }

    public static void spawnParticleClient(World worldIn, IParticleData particle, double x, double y, double z) {
        ModParticles.spawnParticleClient(worldIn, particle, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void spawnParticleClient(World worldIn, IParticleData particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        assert (!(worldIn instanceof ServerWorld)) : "Calling spawnParticleClient on ServerWorld is pointless";
        worldIn.func_195594_a(particle, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public static int spawnParticlesServer(World worldIn, IParticleData particle, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        assert (worldIn instanceof ServerWorld) : "Calling spawnParticlesServer on client side is pointless";
        if (worldIn instanceof ServerWorld) {
            return ((ServerWorld)worldIn).func_195598_a(particle, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed);
        }
        return 0;
    }
}

