/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.Maps;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.inventory.recipes.AlchemicalCauldronRecipe;
import de.teamlapen.vampirism.inventory.recipes.ConfigCondition;
import de.teamlapen.vampirism.inventory.recipes.ShapedItemWithTierRepair;
import de.teamlapen.vampirism.inventory.recipes.ShapedWeaponTableRecipe;
import de.teamlapen.vampirism.inventory.recipes.ShapelessWeaponTableRecipe;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

public class ModRecipes {
    public static final IRecipeType<IWeaponTableRecipe> WEAPONTABLE_CRAFTING_TYPE = IRecipeType.func_222147_a((String)new ResourceLocation("vampirism", "weapontable_crafting").toString());
    public static final IRecipeType<AlchemicalCauldronRecipe> ALCHEMICAL_CAULDRON_TYPE = IRecipeType.func_222147_a((String)new ResourceLocation("vampirism", "alchemical_cauldron").toString());
    @ObjectHolder(value="vampirism:shaped_crafting_weapontable")
    public static final IRecipeSerializer<ShapedWeaponTableRecipe> shaped_crafting_weapontable = (IRecipeSerializer)UtilLib.getNull();
    @ObjectHolder(value="vampirism:shapeless_crafting_weapontable")
    public static final IRecipeSerializer<ShapelessWeaponTableRecipe> shapeless_crafting_weapontable = (IRecipeSerializer)UtilLib.getNull();
    @ObjectHolder(value="vampirism:repair_iitemwithtier")
    public static final IRecipeSerializer<ShapedRecipe> repair_iitemwithtier = (IRecipeSerializer)UtilLib.getNull();
    @ObjectHolder(value="vampirism:alchemical_cauldron")
    public static final IRecipeSerializer<AlchemicalCauldronRecipe> alchemical_cauldron = (IRecipeSerializer)UtilLib.getNull();
    public static final IConditionSerializer<?> CONFIG_CONDITION = CraftingHelper.register((IConditionSerializer)new ConfigCondition.Serializer());
    private static final Map<Item, Integer> liquidColors = Maps.newHashMap();

    static void registerDefaultLiquidColors() {
        ModRecipes.registerLiquidColor(ModItems.holy_water_bottle_normal, 0x6666FF);
        ModRecipes.registerLiquidColor(ModItems.holy_water_bottle_enhanced, 0x6666FF);
        ModRecipes.registerLiquidColor(ModItems.holy_water_bottle_ultimate, 0x6666FF);
        ModRecipes.registerLiquidColor(ModTags.Items.GARLIC, 0xBBBBBB);
    }

    static void registerSerializer(IForgeRegistry<IRecipeSerializer<?>> registry) {
        registry.register(new ShapedWeaponTableRecipe.Serializer().setRegistryName("vampirism", "shaped_crafting_weapontable"));
        registry.register(new ShapelessWeaponTableRecipe.Serializer().setRegistryName("vampirism", "shapeless_crafting_weapontable"));
        registry.register(new ShapedItemWithTierRepair.Serializer().setRegistryName("vampirism", "repair_iitemwithtier"));
        registry.register(new AlchemicalCauldronRecipe.Serializer().setRegistryName("vampirism", "alchemical_cauldron"));
    }

    public static void registerLiquidColor(Item item, int color) {
        liquidColors.put(item, color);
    }

    public static void registerLiquidColor(Tag<Item> items, int color) {
        items.func_199885_a().forEach(item -> liquidColors.put((Item)item, color));
    }

    public static int getLiquidColor(Item stack) {
        return liquidColors.getOrDefault(stack, 0x505050);
    }
}

