/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class CrossbowArrowEntity
extends AbstractArrowEntity
implements IEntityCrossbowArrow {
    @Nonnull
    private ItemStack arrowStack = new ItemStack((IItemProvider)ModItems.crossbow_arrow_normal);
    private boolean ignoreHurtTimer = false;

    public static CrossbowArrowEntity createWithShooter(World world, LivingEntity shooter, double heightOffset, double centerOffset, boolean rightHanded, ItemStack arrow) {
        double yaw = (double)((shooter.field_70177_z - 90.0f) / 180.0f) * Math.PI;
        if (rightHanded) {
            yaw += Math.PI;
        }
        double posX = shooter.field_70165_t - Math.sin(yaw) * centerOffset;
        double posZ = shooter.field_70161_v + Math.cos(yaw) * centerOffset;
        CrossbowArrowEntity entityArrow = new CrossbowArrowEntity(world, posX, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f + heightOffset, posZ, arrow);
        entityArrow.field_70250_c = shooter.func_110124_au();
        if (shooter instanceof PlayerEntity) {
            entityArrow.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
        }
        return entityArrow;
    }

    public CrossbowArrowEntity(EntityType<? extends CrossbowArrowEntity> type, World world) {
        super(type, world);
    }

    public CrossbowArrowEntity(World worldIn, double x, double y, double z, ItemStack arrow) {
        this(ModEntities.crossbow_arrow, worldIn);
        this.func_70107_b(x, y, z);
        this.arrowStack = arrow.func_77946_l();
        this.arrowStack.func_190920_e(1);
    }

    public Random getRNG() {
        return this.field_70146_Z;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.arrowStack.deserializeNBT(compound.func_74775_l("arrowStack"));
    }

    @Override
    public void setIgnoreHurtTimer() {
        this.ignoreHurtTimer = true;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("arrowStack", (INBT)this.arrowStack.func_77955_b(new CompoundNBT()));
    }

    protected void func_184548_a(LivingEntity living) {
        super.func_184548_a(living);
        Item item = this.arrowStack.func_77973_b();
        if (item instanceof IVampirismCrossbowArrow) {
            if (this.ignoreHurtTimer && living.field_70172_ad > 0) {
                living.field_70172_ad = 0;
            }
            ((IVampirismCrossbowArrow)item).onHitEntity(this.arrowStack, living, this, (Entity)(this.field_70250_c == null ? this : (this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.field_70250_c) : null)));
        }
    }

    protected ItemStack func_184550_j() {
        return this.arrowStack;
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        Item item;
        if (raytraceResultIn.func_216346_c() == RayTraceResult.Type.BLOCK && (item = this.arrowStack.func_77973_b()) instanceof IVampirismCrossbowArrow) {
            ((IVampirismCrossbowArrow)item).onHitBlock(this.arrowStack, ((BlockRayTraceResult)raytraceResultIn).func_216350_a(), this, (Entity)(this.field_70250_c == null ? this : (this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.field_70250_c) : null)));
        }
        super.func_184549_a(raytraceResultIn);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

