/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.particle.GenericParticleData;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class DarkBloodProjectileEntity
extends DamagingProjectileEntity {
    protected float directDamage = 4.0f;
    protected float indirecDamage = 2.0f;
    private boolean initialNoClip = false;
    private float motionFactor = 0.97f;
    private boolean excludeShooter = false;

    public DarkBloodProjectileEntity(EntityType<? extends DarkBloodProjectileEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public DarkBloodProjectileEntity(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(ModEntities.dark_blood_projectile, shooter, accelX, accelY, accelZ, worldIn);
    }

    public DarkBloodProjectileEntity(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(ModEntities.dark_blood_projectile, x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public void excludeShooter() {
        this.excludeShooter = true;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.directDamage = compound.func_74760_g("direct_damage");
        this.indirecDamage = compound.func_74760_g("indirect_damage");
    }

    public void setDamage(float direct, float indirect) {
        this.directDamage = direct;
        this.indirecDamage = indirect;
    }

    public void setInitialNoClip() {
        this.initialNoClip = true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("direct_damage", this.directDamage);
        compound.func_74776_a("indirect_damage", this.indirecDamage);
    }

    protected float func_82341_c() {
        return this.motionFactor;
    }

    public void setMotionFactor(float factor) {
        this.motionFactor = factor;
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197605_P;
    }

    public float func_70111_Y() {
        return 0.5f;
    }

    protected boolean func_184564_k() {
        return false;
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.initialNoClip && this.field_70173_aa > 20 && result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                return;
            }
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)result).func_216348_a();
                entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.field_70235_a), this.directDamage);
                if (entity instanceof LivingEntity && this.field_70146_Z.nextInt(3) == 0) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76440_q, 100));
                    ((LivingEntity)entity).func_70653_a((Entity)this, 1.0f, -this.func_213322_ci().field_72450_a, -this.func_213322_ci().field_72449_c);
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1));
                }
            }
            List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g(2.0), EntityPredicates.field_94557_a.and(EntityPredicates.field_180132_d));
            for (Entity e : list) {
                if (this.excludeShooter && e == this.field_70235_a || !(e instanceof LivingEntity) || !(e.func_70068_e((Entity)this) < 4.0)) continue;
                LivingEntity entity = (LivingEntity)e;
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1));
                if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    if (entity == ((EntityRayTraceResult)result).func_216348_a()) continue;
                    entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.field_70235_a), this.indirecDamage);
                    continue;
                }
                entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.field_70235_a), this.indirecDamage);
            }
            Vec3d center = result.func_216347_e();
            ModParticles.spawnParticlesServer(this.field_70170_p, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "spell_1"), 7, 0xA01010, 0.2f), center.field_72450_a, center.field_72448_b, center.field_72449_c, 40, 1.0, 1.0, 1.0, 0.0);
            ModParticles.spawnParticlesServer(this.field_70170_p, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "spell_6"), 10, 0x700505), center.field_72450_a, center.field_72448_b, center.field_72449_c, 15, 1.0, 1.0, 1.0, 0.0);
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            Vec3d center = this.func_174791_d();
            ModParticles.spawnParticlesClient(this.field_70170_p, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "spell_4"), 4, 0xA01010, 0.0f), center.field_72450_a, center.field_72448_b, center.field_72449_c, 5, this.func_70111_Y(), this.field_70146_Z);
            if (this.field_70173_aa % 3 == 0) {
                ModParticles.spawnParticleClient(this.field_70170_p, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "effect_4"), 12, 0xC01010, 0.4f), center.field_72450_a, center.field_72448_b, center.field_72449_c);
            }
        } else if (this.field_70173_aa > 300) {
            this.func_70106_y();
        }
    }
}

