/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.action.vampire;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.action.vampire.VampireEntityAction;
import java.util.UUID;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.Vec3d;

public class SpeedEntityAction<T extends CreatureEntity>
extends VampireEntityAction<T>
implements ILastingAction<T> {
    public static final UUID UUIDS = UUID.fromString("2b49cf70-b634-4e85-8c3e-0147919eaf54");

    public SpeedEntityAction(EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public void activate(T entity) {
    }

    @Override
    public void deactivate(T entity) {
        ((IFactionEntity)entity).getRepresentingEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_188479_b(UUIDS);
    }

    @Override
    public int getCooldown(int level) {
        return (Integer)VampirismConfig.BALANCE.eaSpeedCooldown.get() * 20;
    }

    @Override
    public int getDuration(int level) {
        return (Integer)VampirismConfig.BALANCE.eaSpeedDuration.get() * 20;
    }

    @Override
    public int getWeight(CreatureEntity entity) {
        double distanceToTarget = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v).func_178786_a(entity.func_70638_az().field_70165_t, entity.func_70638_az().field_70163_u, entity.func_70638_az().field_70161_v).func_72433_c();
        if (distanceToTarget > 10.0) {
            return 3;
        }
        if (distanceToTarget > 5.0) {
            return 2;
        }
        return 1;
    }

    @Override
    public void onUpdate(T entity, int duration) {
        if (((IFactionEntity)entity).getRepresentingEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111127_a(UUIDS) == null) {
            ((IFactionEntity)entity).getRepresentingEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(UUIDS, "speedaction", ((Double)VampirismConfig.BALANCE.eaSpeedAmount.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (duration % 5 == 0) {
            double maxDist = 0.5;
            ModParticles.spawnParticlesServer(entity.func_130014_f_(), (IParticleData)ParticleTypes.field_197613_f, ((CreatureEntity)entity).field_70165_t + entity.func_70681_au().nextDouble() * maxDist - maxDist / 2.0, ((CreatureEntity)entity).field_70163_u + 0.1, ((CreatureEntity)entity).field_70161_v + entity.func_70681_au().nextDouble() * maxDist - maxDist / 2.0, 3, 0.3f, 0.3f, 0.3f, 0.02f);
        }
    }
}

