/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.ICaptureIgnore;
import de.teamlapen.vampirism.entity.goals.LookAtTrainerHunterGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.inventory.container.HunterTrainerContainer;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class HunterTrainerEntity
extends HunterBaseEntity
implements LookAtTrainerHunterGoal.ITrainer,
ICaptureIgnore {
    private static final ITextComponent name = new TranslationTextComponent("container.huntertrainer", new Object[0]);
    private final int MOVE_TO_RESTRICT_PRIO = 3;
    private PlayerEntity trainee;
    private boolean shouldCreateHome;

    public HunterTrainerEntity(EntityType<? extends HunterTrainerEntity> type, World world) {
        super(type, world, false);
        this.saveHome = true;
        this.hasArms = true;
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.setDontDropEquipment();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return super.func_213397_c(distanceToClosestPlayer) && this.getHome() == null;
    }

    public boolean func_94059_bO() {
        return true;
    }

    @Override
    @Nullable
    public PlayerEntity getTrainee() {
        return this.trainee;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.trainee != null && !(this.trainee.field_71070_bA instanceof HunterTrainerContainer)) {
            this.trainee = null;
        }
    }

    @Override
    public void setHome(AxisAlignedBB box) {
        super.setHome(box);
        this.setMoveTowardsRestriction(3, true);
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("createHome") && (this.shouldCreateHome = nbt.func_74767_n("createHome")) && this.func_213384_dI().equals((Object)BlockPos.field_177992_a)) {
            this.func_213390_a(this.func_180425_c(), 5);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("createHome", this.shouldCreateHome);
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        boolean flag;
        if (this.tryCureSanguinare(player)) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = flag = !stack.func_190926_b() && stack.func_77973_b() instanceof SpawnEggItem;
        if (!flag && this.func_70089_S() && !player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                if (HunterLevelingConf.instance().isLevelValidForTrainer((Integer)HunterPlayer.getOpt(player).map(VampirismPlayer::getLevel).orElse((Object)0) + 1)) {
                    if (this.trainee == null) {
                        player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, playerEntity) -> new HunterTrainerContainer(id, playerInventory, this), name));
                        this.trainee = player;
                        this.func_70661_as().func_75499_g();
                    } else {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.i_am_busy_right_now", new Object[0]));
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.hunter_trainer.trainer_level_wrong", new Object[0]));
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(19.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.17);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(5.0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, new LookAtTrainerHunterGoal<HunterTrainerEntity>(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 13.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, VampireBaseEntity.class, 17.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
    }
}

