/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.special;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.AreaParticleCloudEntity;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.util.HalloweenSpecial;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DraculaHalloweenEntity
extends VampirismEntity {
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(DraculaHalloweenEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final Logger LOGGER = LogManager.getLogger(DraculaHalloweenEntity.class);
    private int seen = 0;
    private int hiding = 0;
    private boolean particle = false;

    public DraculaHalloweenEntity(EntityType<? extends DraculaHalloweenEntity> type, World world) {
        super(type, world);
        this.func_184224_h(true);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public boolean isParticle() {
        return this.particle;
    }

    public void setParticle(boolean particle) {
        this.particle = particle;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!HalloweenSpecial.isEnabled()) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            LivingEntity owner = this.getOwner();
            if (owner != null && !this.func_82150_aj() && !((PlayerEntity)owner).func_175144_cb()) {
                this.func_82142_c(true);
                LOGGER.info("Setting invisible on other client");
            }
            return;
        }
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            this.func_70106_y();
            return;
        }
        if (this.func_130014_f_().func_72935_r()) {
            if (this.hiding == 0) {
                this.makeHide(this.func_70681_au().nextInt(1000));
            }
            return;
        }
        if (this.hiding == 0) {
            if (UtilLib.canReallySee(owner, (LivingEntity)this, true)) {
                ++this.seen;
                if (this.seen == 1 && owner instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)owner).field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(ModSounds.entity_vampire_scream, SoundCategory.NEUTRAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, 1.0f));
                }
            } else if (this.func_70068_e((Entity)owner) > 5.0) {
                this.teleportBehind(owner);
            }
            if (this.seen > 5) {
                AreaParticleCloudEntity particleCloud = (AreaParticleCloudEntity)ModEntities.particle_cloud.func_200721_a(this.func_130014_f_());
                particleCloud.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                particleCloud.setRadius(0.7f);
                particleCloud.setHeight(this.func_213302_cg());
                particleCloud.setDuration(3);
                particleCloud.setSpawnRate(10.0f);
                this.func_130014_f_().func_217376_c((Entity)particleCloud);
                if (this.func_70681_au().nextInt(3) == 0) {
                    this.teleportBehind(owner);
                } else if (this.func_70681_au().nextInt(3) == 0) {
                    this.func_70106_y();
                } else {
                    this.makeHide(this.func_70681_au().nextInt(3000));
                }
                this.seen = 0;
            }
        } else {
            --this.hiding;
            if (this.hiding == 0) {
                this.teleportBehind(owner);
                this.func_82142_c(false);
            }
        }
    }

    public void makeHide(int time) {
        this.seen = 0;
        this.func_82142_c(true);
        BlockPos spawn = this.field_70170_p.func_175694_M();
        this.func_70107_b(spawn.func_177958_n(), 3.0, spawn.func_177952_p());
        this.hiding = time;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_70106_y();
    }

    public CompoundNBT func_189511_e(CompoundNBT compound) {
        return super.func_189511_e(compound);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f, 1.0f));
    }

    private void teleportBehind(LivingEntity target) {
        BlockPos behind = UtilLib.getPositionBehindEntity(target, 1.5f);
        this.func_70107_b(behind.func_177958_n(), target.field_70163_u, behind.func_177952_p());
        if (!this.func_205019_a((IWorldReader)this.func_130014_f_())) {
            int y = this.func_130014_f_().func_205770_a(Heightmap.Type.WORLD_SURFACE, behind).func_177956_o();
            this.func_70107_b(behind.func_177958_n(), y, behind.func_177952_p());
        }
    }
}

