/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.items.HunterCoatItem;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class VampireBaseEntity
extends VampirismEntity
implements IVampireMob {
    private final boolean countAsMonsterForSpawn;
    private SpawnRestriction spawnRestriction = SpawnRestriction.NORMAL;
    protected EnumStrength garlicResist = EnumStrength.NONE;
    protected boolean canSuckBloodFromPlayer = false;
    protected boolean vulnerableToFire = true;
    private boolean sundamageCache;
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean dropSoul = false;

    public static boolean spawnPredicateVampire(EntityType<? extends VampirismEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && (VampireBaseEntity.spawnPredicateLight(world, blockPos, random) || VampireBaseEntity.spawnPredicateVampireFog(world, blockPos)) && VampireBaseEntity.spawnPredicateCanSpawn(entityType, world, spawnReason, blockPos, random);
    }

    public VampireBaseEntity(EntityType<? extends VampireBaseEntity> type, World world, boolean countAsMonsterForSpawn) {
        super(type, world);
        this.countAsMonsterForSpawn = countAsMonsterForSpawn;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (this.canSuckBloodFromPlayer && !this.field_70170_p.field_72995_K && this.wantsBlood() && entity instanceof PlayerEntity && !Helper.isHunter(entity) && !UtilLib.canReallySee((LivingEntity)entity, (LivingEntity)this, true)) {
            int amt = (Integer)VampirePlayer.getOpt((PlayerEntity)entity).map(v -> v.onBite(this)).orElse((Object)0);
            this.drinkBlood(amt, 0.7f);
            return true;
        }
        for (ItemStack e : entity.func_184193_aE()) {
            if (e == null || !(e.func_77973_b() instanceof HunterCoatItem)) continue;
            int j = 1;
            if (((HunterCoatItem)e.func_77973_b()).getVampirismTier().equals((Object)IItemWithTier.TIER.ENHANCED)) {
                j = 2;
            } else if (((HunterCoatItem)e.func_77973_b()).getVampirismTier().equals((Object)IItemWithTier.TIER.ULTIMATE)) {
                j = 3;
            }
            if (this.func_70681_au().nextInt((4 - j) * 2) != 0) continue;
            this.func_195064_c(new EffectInstance(ModEffects.poison, (int)(20.0 * Math.sqrt(j)), j));
        }
        return super.func_70652_k(entity);
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (this.vulnerableToFire) {
            if (DamageSource.field_76372_a.equals(damageSource)) {
                return this.func_70097_a(VReference.VAMPIRE_IN_FIRE, this.calculateFireDamage(amount));
            }
            if (DamageSource.field_76370_b.equals(damageSource)) {
                return this.func_70097_a(VReference.VAMPIRE_ON_FIRE, this.calculateFireDamage(amount));
            }
        }
        return super.func_70097_a(damageSource, amount);
    }

    public EntityClassification getClassification(boolean forSpawnCount) {
        if (forSpawnCount && this.countAsMonsterForSpawn) {
            return EntityClassification.MONSTER;
        }
        return super.getClassification(forSpawnCount);
    }

    @Override
    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        if (this.spawnRestriction.level >= SpawnRestriction.SIMPLE.level) {
            if (this.isGettingSundamage(worldIn, true) || this.isGettingGarlicDamage(worldIn, true) != EnumStrength.NONE) {
                return false;
            }
            if (this.spawnRestriction.level >= SpawnRestriction.NORMAL.level) {
                BlockPos nearestVillage;
                if (worldIn.func_201675_m().isDaytime() && this.field_70146_Z.nextInt(5) != 0) {
                    return false;
                }
                if (this.field_70170_p.func_195588_v(this.func_180425_c()) && worldIn instanceof World && (nearestVillage = ((World)worldIn).func_211157_a("Village", this.func_180425_c(), 1, false)) != null && nearestVillage.func_218141_a((Vec3i)this.func_180425_c(), 50.0) && this.func_70681_au().nextInt(60) != 0) {
                    return false;
                }
                if (this.spawnRestriction.level >= SpawnRestriction.SPECIAL.level && !this.getCanSpawnHereRestricted(worldIn)) {
                    return false;
                }
            }
        }
        return super.func_213380_a(worldIn, spawnReasonIn);
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return !strength.isStrongerThan(this.garlicResist);
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.func_195064_c(new EffectInstance(Effects.field_76428_l, amt * 20));
    }

    public CreatureAttribute func_70668_bt() {
        return VReference.VAMPIRE_CREATURE_ATTRIBUTE;
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(IWorld iWorld, boolean forcerefresh) {
        if (forcerefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(IWorld iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.field_70170_p.func_217381_Z());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.func_70644_a(ModEffects.sunscreen);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70173_aa % 40 == 3) {
            this.isGettingGarlicDamage((IWorld)this.field_70170_p, true);
        }
        if (this.field_70173_aa % 8 == 2) {
            this.isGettingSundamage((IWorld)this.field_70170_p, true);
        }
        if (!this.field_70170_p.field_72995_K) {
            double dmg;
            if (this.isGettingSundamage((IWorld)this.field_70170_p) && this.field_70173_aa % 40 == 11 && (dmg = this.func_110148_a(VReference.sunDamage).func_111126_e()) > 0.0) {
                this.func_70097_a(VReference.SUNDAMAGE, (float)dmg);
            }
            if (this.isGettingGarlicDamage((IWorld)this.field_70170_p) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((IWorld)this.field_70170_p), this.field_70173_aa);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70090_H()) {
            this.func_70050_g(300);
            if (this.field_70173_aa % 16 == 4) {
                this.func_195064_c(new EffectInstance(Effects.field_76437_t, 80, 0));
            }
        }
        super.func_70636_d();
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76364_f() instanceof CrossbowArrowEntity && Helper.isHunter(cause.func_76346_g())) {
            this.dropSoul = true;
        } else if (cause.func_76364_f() instanceof PlayerEntity && Helper.isHunter(cause.func_76364_f())) {
            ItemStack weapon = ((PlayerEntity)cause.func_76364_f()).func_184614_ca();
            if (!weapon.func_190926_b() && weapon.func_77973_b() instanceof IVampireFinisher) {
                this.dropSoul = true;
            }
        } else {
            this.dropSoul = false;
        }
    }

    public void setSpawnRestriction(SpawnRestriction r) {
        this.spawnRestriction = r;
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.func_195064_c(new EffectInstance(Effects.field_76437_t, amt * 20));
        return true;
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    protected float calculateFireDamage(float amount) {
        return amount;
    }

    protected void func_70609_aI() {
        if (this.field_70725_aQ == 19 && !this.field_70170_p.field_72995_K && this.dropSoul && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            this.field_70170_p.func_217376_c((Entity)new SoulOrbEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoulOrbEntity.VARIANT.VAMPIRE));
        }
        super.func_70609_aI();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        IAttributeInstance iAttributeInstance = this.func_110140_aT().func_111150_b(VReference.sunDamage);
        BalanceMobProps.mobProps.getClass();
        iAttributeInstance.func_111128_a(7.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
    }

    private boolean getCanSpawnHereRestricted(IWorld iWorld) {
        boolean vampireBiome = ModBiomes.vampire_forest.equals(iWorld.func_180494_b(this.func_180425_c()));
        if (!vampireBiome) {
            return this.isLowLightLevel(iWorld);
        }
        BlockState iblockstate = iWorld.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return ((Object)((Object)ModBlocks.cursed_earth)).equals(iblockstate.func_177230_c());
    }

    public static enum SpawnRestriction {
        NONE(0),
        SIMPLE(1),
        NORMAL(2),
        SPECIAL(3);

        int level;

        private SpawnRestriction(int level) {
            this.level = level;
        }
    }
}

