/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.recipes;

import com.google.gson.JsonObject;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.inventory.recipes.VampirismRecipeHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedWeaponTableRecipe
implements ICraftingRecipe,
IWeaponTableRecipe,
IShapedRecipe<CraftingInventory> {
    protected static int MAX_WIDTH = 4;
    protected static int MAX_HEIGHT = 4;
    private final ResourceLocation id;
    private final String group;
    private final int recipeWidth;
    private final int recipeHeight;
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack recipeOutput;
    private final int requiredLevel;
    @Nonnull
    private final ISkill[] requiredSkills;
    private final int requiredLava;

    public ShapedWeaponTableRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, int requiredLevel, @Nonnull ISkill[] requiredSkills, int requiredLava) {
        this.id = idIn;
        this.group = groupIn;
        this.recipeWidth = recipeWidthIn;
        this.recipeHeight = recipeHeightIn;
        this.recipeItems = recipeItemsIn;
        this.recipeOutput = recipeOutputIn;
        this.requiredLevel = requiredLevel;
        this.requiredSkills = requiredSkills;
        this.requiredLava = requiredLava;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }

    @Override
    public ItemStack getCraftingResult(CraftingInventory inv) {
        return this.recipeOutput.func_77946_l();
    }

    public String func_193358_e() {
        return this.group;
    }

    public int getHeight() {
        return this.recipeHeight;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public int getRecipeHeight() {
        return this.getHeight();
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public int getRecipeWidth() {
        return this.getWidth();
    }

    @Override
    public int getRequiredLavaUnits() {
        return this.requiredLava;
    }

    @Override
    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    @Override
    public ISkill[] getRequiredSkills() {
        return this.requiredSkills;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.shaped_crafting_weapontable;
    }

    public IRecipeType<? extends IRecipe> func_222127_g() {
        return ModRecipes.WEAPONTABLE_CRAFTING_TYPE;
    }

    public int getWidth() {
        return this.recipeWidth;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        for (int i = 0; i <= inv.func_174922_i() - this.recipeWidth; ++i) {
            for (int j = 0; j <= inv.func_174923_h() - this.recipeHeight; ++j) {
                if (this.checkMatch(inv, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(CraftingInventory craftingInventory, int startRow, int startColumn, boolean p_77573_4_) {
        for (int i = 0; i < craftingInventory.func_174922_i(); ++i) {
            for (int j = 0; j < craftingInventory.func_174923_h(); ++j) {
                int k = i - startRow;
                int l = j - startColumn;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    ingredient = p_77573_4_ ? (Ingredient)this.recipeItems.get(this.recipeWidth - k - 1 + l * this.recipeWidth) : (Ingredient)this.recipeItems.get(k + l * this.recipeWidth);
                }
                if (ingredient.test(craftingInventory.func_70301_a(i + j * craftingInventory.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapedWeaponTableRecipe> {
        public ShapedWeaponTableRecipe read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map<String, Ingredient> map = VampirismRecipeHelper.deserializeKey(JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] astring = VampirismRecipeHelper.shrink(VampirismRecipeHelper.patternFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern"), MAX_HEIGHT));
            int height = astring[0].length();
            int length = astring.length;
            NonNullList<Ingredient> ingredients = VampirismRecipeHelper.deserializeIngredients(astring, map, height, length);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            int level = JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1);
            ISkill[] skill = VampirismRecipeHelper.deserializeSkills(JSONUtils.func_151213_a((JsonObject)json, (String)"skill", null));
            int lava = JSONUtils.func_151208_a((JsonObject)json, (String)"lava", (int)0);
            return new ShapedWeaponTableRecipe(recipeId, group, height, length, ingredients, result, level, skill, lava);
        }

        public ShapedWeaponTableRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int width = buffer.func_150792_a();
            int height = buffer.func_150792_a();
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.func_191197_a((int)(height * width), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            int level = buffer.func_150792_a();
            int lava = buffer.func_150792_a();
            ISkill[] skills = new ISkill[buffer.func_150792_a()];
            if (skills.length != 0) {
                for (int i = 0; i < skills.length; ++i) {
                    skills[i] = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE)));
                }
            }
            return new ShapedWeaponTableRecipe(recipeId, group, height, width, (NonNullList<Ingredient>)ingredients, itemstack, level, skills, lava);
        }

        public void write(PacketBuffer buffer, ShapedWeaponTableRecipe recipe) {
            buffer.func_150787_b(recipe.recipeWidth);
            buffer.func_150787_b(recipe.recipeHeight);
            buffer.func_180714_a(recipe.group);
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.recipeOutput);
            buffer.func_150787_b(recipe.requiredLevel);
            buffer.func_150787_b(recipe.requiredLava);
            buffer.func_150787_b(recipe.requiredSkills.length);
            if (recipe.requiredSkills.length != 0) {
                for (ISkill skill : recipe.requiredSkills) {
                    buffer.func_180714_a(skill.getRegistryName().toString());
                }
            }
        }
    }
}

