/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.blocks.TentMainBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.items.VampirismItem;
import de.teamlapen.vampirism.tileentity.TentTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TentItem
extends VampirismItem {
    private static final String name = "item_tent";
    private static final String name_spawner = "item_tent_spawner";
    private final boolean spawner;

    public static boolean placeAt(IWorld world, BlockPos pos, Direction dir, boolean force, boolean spawner) {
        boolean flag;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int x1 = x + (dir == Direction.SOUTH ? 1 : (dir == Direction.NORTH ? -1 : 0));
        int z1 = z + (dir == Direction.WEST ? 1 : (dir == Direction.EAST ? -1 : 0));
        int x2 = x + (dir == Direction.WEST ? -1 : (dir == Direction.NORTH ? -1 : 1));
        int z2 = z + (dir == Direction.SOUTH || dir == Direction.WEST ? 1 : -1);
        int x3 = x + (dir == Direction.WEST ? -1 : (dir == Direction.EAST ? 1 : 0));
        int z3 = z + (dir == Direction.SOUTH ? 1 : (dir == Direction.NORTH ? -1 : 0));
        TentBlock tent = ModBlocks.tent;
        TentMainBlock main = ModBlocks.tent_main;
        BlockState mainState = main.func_176223_P();
        if ((force || TentItem.canPlaceAt(mainState, tent, world, x, y, z) && TentItem.canPlaceAt(mainState, tent, world, x1, y, z1) && TentItem.canPlaceAt(mainState, tent, world, x2, y, z2) && TentItem.canPlaceAt(mainState, tent, world, x3, y, z3)) && (flag = world.func_180501_a(pos, (BlockState)main.func_176223_P().func_206870_a((IProperty)TentBlock.FACING, (Comparable)dir.func_176734_d()), 3))) {
            TileEntity tile;
            world.func_180501_a(new BlockPos(x1, y, z1), (BlockState)((BlockState)tent.func_176223_P().func_206870_a((IProperty)TentBlock.FACING, (Comparable)dir)).func_206870_a((IProperty)TentBlock.POSITION, (Comparable)Integer.valueOf(1)), 3);
            world.func_180501_a(new BlockPos(x2, y, z2), (BlockState)((BlockState)tent.func_176223_P().func_206870_a((IProperty)TentBlock.FACING, (Comparable)dir)).func_206870_a((IProperty)TentBlock.POSITION, (Comparable)Integer.valueOf(2)), 3);
            world.func_180501_a(new BlockPos(x3, y, z3), (BlockState)((BlockState)tent.func_176223_P().func_206870_a((IProperty)TentBlock.FACING, (Comparable)dir.func_176734_d())).func_206870_a((IProperty)TentBlock.POSITION, (Comparable)Integer.valueOf(3)), 3);
            if (spawner && (tile = world.func_175625_s(pos)) instanceof TentTileEntity) {
                ((TentTileEntity)tile).setSpawn(true);
            }
            return true;
        }
        return false;
    }

    private static boolean canPlaceAt(BlockState state, Block block, IWorld world, int x, int y, int z) {
        return block.func_196260_a(state, (IWorldReader)world, new BlockPos(x, y, z));
    }

    public TentItem(boolean spawner) {
        super(spawner ? name_spawner : name, new Item.Properties().func_200916_a(VampirismMod.creativeTab));
        this.spawner = spawner;
        this.setTranslation_key(name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.spawner) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tile.vampirism.tent.spawner", new Object[0]));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        if (ctx.func_196000_l() != Direction.UP) {
            return ActionResultType.PASS;
        }
        if (ctx.func_195991_k().field_72995_K) {
            return ActionResultType.PASS;
        }
        ItemStack stack = ctx.func_195996_i();
        PlayerEntity player = ctx.func_195999_j();
        Direction dir = player == null ? Direction.NORTH : Direction.func_176733_a((double)ctx.func_195999_j().field_70177_z);
        boolean flag = TentItem.placeAt((IWorld)ctx.func_195991_k(), ctx.func_195995_a().func_177984_a(), dir, false, false);
        if (flag) {
            TileEntity tile = ctx.func_195991_k().func_175625_s(ctx.func_195995_a().func_177984_a());
            if (tile instanceof TentTileEntity && this.spawner) {
                ((TentTileEntity)tile).setSpawn(true);
            }
            if (player == null || !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        return flag ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }
}

