/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.items.VampirismItem;
import de.teamlapen.vampirism.network.OpenVampireBookPacket;
import de.teamlapen.vampirism.util.VampireBookManager;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WritableBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VampireBookItem
extends VampirismItem {
    private static final String regName = "vampire_book";

    public static boolean validBookTagContents(CompoundNBT nbt) {
        if (!WritableBookItem.func_150930_a((CompoundNBT)nbt)) {
            return false;
        }
        if (!nbt.func_74764_b("title")) {
            return false;
        }
        String s = nbt.func_74779_i("title");
        return s.length() <= 32 && nbt.func_74764_b("author");
    }

    public VampireBookItem() {
        super(regName, new Item.Properties().func_200917_a(1).func_200916_a(VampirismMod.creativeTab));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)VampireBookManager.getInstance().getRandomBook(new Random()));
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT nbttagcompound;
        String s;
        if (stack.func_77942_o() && !StringUtils.func_151246_b((String)(s = (nbttagcompound = stack.func_77978_p()).func_74779_i("title")))) {
            return new StringTextComponent(s);
        }
        return super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            this.resolveContents(stack, playerIn);
            VampirismMod.dispatcher.sendTo(new OpenVampireBookPacket(stack), (ServerPlayerEntity)playerIn);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    private void resolveContents(ItemStack stack, PlayerEntity player) {
        CompoundNBT nbttagcompound;
        if (!stack.func_190926_b() && stack.func_77978_p() != null && !(nbttagcompound = stack.func_77978_p()).func_74767_n("resolved")) {
            nbttagcompound.func_74757_a("resolved", true);
            if (VampireBookItem.validBookTagContents(nbttagcompound)) {
                ListNBT nbttaglist = nbttagcompound.func_150295_c("pages", 8);
                for (int slot = 0; slot < nbttaglist.size(); ++slot) {
                    StringTextComponent lvt_7_1_;
                    String s = nbttaglist.func_150307_f(slot);
                    try {
                        ITextComponent var11 = ITextComponent.Serializer.func_186877_b((String)s);
                        lvt_7_1_ = TextComponentUtils.func_197680_a(null, (ITextComponent)var11, (Entity)player, (int)0);
                    }
                    catch (Exception var9) {
                        lvt_7_1_ = new StringTextComponent(s);
                    }
                    nbttaglist.set(slot, (INBT)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)((ITextComponent)lvt_7_1_))));
                }
                nbttagcompound.func_218657_a("pages", (INBT)nbttaglist);
                if (player instanceof ServerPlayerEntity && player.func_184614_ca() == stack) {
                    Slot var10 = (Slot)player.field_71070_bA.field_75151_b.get(player.field_71071_by.field_70461_c);
                    ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(0, var10.field_75222_d, stack));
                }
            }
        }
    }
}

