/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.model.CloakModel;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VampireCloakItem
extends ArmorItem {
    private final String registeredName = "vampire_cloak";
    private final EnumCloakColor color;

    public VampireCloakItem(EnumCloakColor color) {
        super((IArmorMaterial)ArmorMaterial.LEATHER, EquipmentSlotType.CHEST, new Item.Properties().func_200915_b(0).func_200916_a(VampirismMod.creativeTab));
        this.setRegistryName("vampirism", "vampire_cloak_" + color.func_176610_l());
        this.color = color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        PlayerEntity playerEntity = VampirismMod.proxy.getClientPlayer();
        if (playerEntity != null && Helper.isHunter(playerEntity)) {
            tooltip.add(new TranslationTextComponent("text.vampirism.poisonous_to_hunter", new Object[0]).func_211708_a(TextFormatting.RED));
        }
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, BipedModel _default) {
        return new CloakModel();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return String.format("vampirism:textures/models/armor/%s/%s_%s", "vampire_cloak", "vampire_cloak", this.color.func_176610_l() + ".png");
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        super.onArmorTick(stack, world, player);
        if (player.field_70173_aa % 16 == 8 && Helper.isHunter(player)) {
            player.func_195064_c(new EffectInstance(ModEffects.poison, 20, 1));
        }
    }

    public static enum EnumCloakColor implements IStringSerializable
    {
        REDBLACK("red_black"),
        BLACKRED("black_red"),
        BLACKWHITE("black_white"),
        WHITEBLACK("white_black"),
        BLACKBLUE("black_blue");

        private final String name;

        private EnumCloakColor(String nameIn) {
            this.name = nameIn;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

