/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat;

import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.config.forge.Configuration;
import de.teamlapen.lib.lib.config.forge.Property;
import de.teamlapen.vampirism.VampirismMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.StringUtils;

public class IntegrationsNotifier {
    private static final String[] available_compats = new String[0];

    public static List<String> shouldNotifyAboutIntegrations() {
        if (!ModList.get().isLoaded("vampirism_integrations")) {
            ArrayList installedMods = Lists.newArrayList();
            for (String s : available_compats) {
                if (!ModList.get().isLoaded(s)) continue;
                installedMods.add(s);
            }
            if (installedMods.size() > 0 && !IntegrationsNotifier.checkAndUpdateAlreadyNotified(installedMods)) {
                return installedMods;
            }
        }
        return Collections.emptyList();
    }

    private static boolean checkAndUpdateAlreadyNotified(List<String> mods) {
        Configuration config = VampirismMod.instance.modCompatLoader.getConfig();
        assert (config != null) : "Do not call before init";
        Property conf = config.get("general", "integration_mod_notification", "", "INTERNAL - Set to 'never' if you don't want to be notified about integration mods");
        String saved = conf.getString();
        if ("never".equals(saved) || "'never'".equals(saved)) {
            return true;
        }
        String[] previous = saved.split(":");
        ArrayList<String> missing = new ArrayList<String>(mods);
        missing.removeAll(Arrays.asList(previous));
        if (missing.size() == 0) {
            return true;
        }
        Collections.addAll(missing, previous);
        conf.set(StringUtils.join(missing, (String)":"));
        config.save();
        return false;
    }
}

