/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player;

import com.google.common.base.Throwables;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.blocks.AltarInspirationBlock;
import de.teamlapen.vampirism.blocks.BloodContainerBlock;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.GarlicBreadItem;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.HunterPlayerSpecialAttribute;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayerSpecialAttributes;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.REFERENCE;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModPlayerEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(ModPlayerEventHandler.class);

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            try {
                event.addCapability(REFERENCE.FACTION_PLAYER_HANDLER_KEY, FactionPlayerHandler.createNewCapability((PlayerEntity)event.getObject()));
                event.addCapability(REFERENCE.VAMPIRE_PLAYER_KEY, VampirePlayer.createNewCapability((PlayerEntity)event.getObject()));
                event.addCapability(REFERENCE.HUNTER_PLAYER_KEY, HunterPlayer.createNewCapability((PlayerEntity)event.getObject()));
            }
            catch (Exception e) {
                LOGGER.error("Failed to attach capabilities to player. Player: {}", event.getObject());
                Throwables.propagate((Throwable)e);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackEntity(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_70089_S()) {
            if (VampirePlayer.get((PlayerEntity)player).getSpecialAttributes().bat || HunterPlayer.get(player).getSpecialAttributes().isDisguised()) {
                event.setCanceled(true);
            }
            if (!this.checkItemUsePerm(player.func_184614_ca(), player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity) || !event.getEntity().func_70089_S()) {
            return;
        }
        try {
            if (VampirePlayer.get((PlayerEntity)((PlayerEntity)event.getEntity())).getSpecialAttributes().bat || HunterPlayer.get((PlayerEntity)event.getEntity()).getSpecialAttributes().isDisguised()) {
                event.setCanceled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (((Boolean)VampirePlayer.getOpt(event.getPlayer()).map(VampirePlayer::getSpecialAttributes).map(s -> s.bat).orElse((Object)false)).booleanValue() || ((Boolean)HunterPlayer.getOpt(event.getPlayer()).map(HunterPlayer::getSpecialAttributes).map(HunterPlayerSpecialAttribute::isDisguised).orElse((Object)false)).booleanValue()) {
            event.setCanceled(true);
        } else if ((((Object)((Object)ModBlocks.garlic_beacon_normal)).equals(event.getState().func_177230_c()) || ((Object)((Object)ModBlocks.garlic_beacon_weak)).equals(event.getState().func_177230_c()) || ((Object)((Object)ModBlocks.garlic_beacon_improved)).equals(event.getState().func_177230_c())) && (Integer)VampirePlayer.getOpt(event.getPlayer()).map(VampirismPlayer::getLevel).orElse((Object)0) > 0) {
            event.setNewSpeed(event.getOriginalSpeed() * 0.1f);
        }
    }

    @SubscribeEvent
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        if (!this.checkItemUsePerm(event.getItemStack(), event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity() instanceof PlayerEntity && (((Boolean)VampirePlayer.getOpt((PlayerEntity)event.getEntity()).map(VampirePlayer::getSpecialAttributes).map(s -> s.bat).orElse((Object)false)).booleanValue() || ((Boolean)HunterPlayer.getOpt((PlayerEntity)event.getEntity()).map(HunterPlayer::getSpecialAttributes).map(HunterPlayerSpecialAttribute::isDisguised).orElse((Object)false)).booleanValue())) {
            event.setCanceled(true);
        }
        if (event.getEntity() instanceof PlayerEntity && !this.checkItemUsePerm(event.getItem(), (PlayerEntity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(LivingEntityUseItemEvent.Finish event) {
        if (Helper.isVampire(event.getEntity()) && event.getItem().func_77973_b() instanceof GarlicBreadItem && !event.getEntity().func_130014_f_().field_72995_K) {
            DamageHandler.affectVampireGarlicDirect(event.getEntity() instanceof IVampire ? (IVampire)event.getEntity() : VampirePlayer.get((PlayerEntity)event.getEntity()), EnumStrength.MEDIUM);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntity() instanceof PlayerEntity && !((Boolean)FactionPlayerHandler.getOpt((PlayerEntity)event.getEntity()).map(h -> h.onEntityAttacked(event.getSource(), event.getAmount())).orElse((Object)false)).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            event.setDistance(event.getDistance() - (float)((Integer)VampirePlayer.getOpt((PlayerEntity)event.getEntity()).map(VampirePlayer::getSpecialAttributes).map(VampirePlayerSpecialAttributes::getJumpBoost).orElse((Object)0)).intValue());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHeal(LivingHealEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && ((Boolean)VampirePlayer.getOpt((PlayerEntity)event.getEntityLiving()).map(VampirePlayer::getSpecialAttributes).map(s -> s.bat).orElse((Object)false)).booleanValue()) {
            event.setAmount(event.getAmount() * 0.1f);
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            event.getEntity().func_213317_d(event.getEntity().func_213322_ci().func_72441_c(0.0, (double)((float)((Integer)VampirePlayer.getOpt((PlayerEntity)event.getEntity()).map(VampirePlayer::getSpecialAttributes).map(VampirePlayerSpecialAttributes::getJumpBoost).orElse((Object)0)).intValue() * 0.1f), 0.0));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.getPlayer().func_130014_f_().field_72995_K) {
            FactionPlayerHandler.get(event.getEntityPlayer()).copyFrom(event.getOriginal());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldStack;
        if (event.getWorld().func_175723_af().func_177746_a(event.getPos()) && !(heldStack = event.getItemStack()).func_190926_b() && heldStack.func_190916_E() == 1) {
            boolean glasBottle = Items.field_151069_bo.equals(heldStack.func_77973_b());
            boolean bloodBottle = ((Object)((Object)ModItems.blood_bottle)).equals(heldStack.func_77973_b());
            if (bloodBottle || glasBottle && ((Boolean)VampirismConfig.SERVER.autoConvertGlassBottles.get()).booleanValue()) {
                TileEntity entity;
                Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
                BlockState state = event.getWorld().func_180495_p(event.getPos());
                boolean convert = false;
                if (glasBottle && state.hasTileEntity() && (entity = event.getWorld().func_175625_s(event.getPos())) != null) {
                    convert = (Boolean)entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, event.getFace()).map(fluidHandler -> {
                        boolean flag = false;
                        FluidStack drain = fluidHandler.drain(new FluidStack(ModFluids.blood, 1000), IFluidHandler.FluidAction.SIMULATE);
                        if (drain.getAmount() >= 100) {
                            flag = true;
                        }
                        if (flag && block instanceof AltarInspirationBlock) {
                            flag = false;
                        }
                        if (flag && block instanceof BloodContainerBlock) {
                            flag = false;
                        }
                        return flag;
                    }).orElse((Object)false);
                }
                if ((bloodBottle || convert) && block instanceof BloodContainerBlock) {
                    event.setUseBlock(Event.Result.ALLOW);
                }
                if (convert) {
                    Hand hand = heldStack.equals(event.getEntityPlayer().func_184614_ca()) ? Hand.MAIN_HAND : (heldStack.equals(event.getEntityPlayer().func_184592_cb()) ? Hand.OFF_HAND : Hand.MAIN_HAND);
                    heldStack = new ItemStack((IItemProvider)ModItems.blood_bottle);
                    event.getEntityPlayer().func_184611_a(hand, heldStack);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftLickedBlock(PlayerInteractEvent.LeftClickBlock event) {
        assert (event.getFace() != null);
        BlockPos pos = event.getPos().func_177972_a(event.getFace());
        World world = event.getWorld();
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == ModBlocks.alchemical_fire) {
            world.func_217378_a(null, 1009, pos, 0);
            world.func_217377_a(pos, false);
            event.setCanceled(true);
        } else if ((((Object)((Object)ModBlocks.garlic_beacon_normal)).equals(state.func_177230_c()) || ((Object)((Object)ModBlocks.garlic_beacon_weak)).equals(state.func_177230_c()) || ((Object)((Object)ModBlocks.garlic_beacon_improved)).equals(state.func_177230_c())) && Helper.isVampire(event.getEntityPlayer())) {
            event.getEntityPlayer().func_195064_c(new EffectInstance(ModEffects.garlic));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerName(PlayerEvent.NameFormat event) {
        if (event.getPlayer() != null && ((Boolean)VampirismConfig.SERVER.factionColorInChat.get()).booleanValue()) {
            ((Optional)FactionPlayerHandler.getOpt(event.getPlayer()).map(FactionPlayerHandler::getCurrentFactionPlayer).orElse(Optional.empty())).ifPresent(fp -> {
                IFaction f = fp.getDisguisedAs();
                if (f != null) {
                    event.setDisplayname(f.getChatColor() + event.getDisplayname() + TextFormatting.RESET);
                    if (fp instanceof IVampirePlayer && !fp.isDisguised() && ((IVampirePlayer)fp).isVampireLord()) {
                        event.setDisplayname(TextFormatting.RED + "[" + UtilLib.translate("text.vampirism.lord", new Object[0]) + "] " + TextFormatting.RESET + event.getDisplayname());
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerVisibilityCheck(PlayerEvent.Visibility event) {
        if (((Boolean)HunterPlayer.getOpt(event.getPlayer()).map(HunterPlayer::getSpecialAttributes).map(HunterPlayerSpecialAttribute::isDisguised).orElse((Object)false)).booleanValue()) {
            event.modifyVisibility(((Double)VampirismConfig.BALANCE.haDisguiseVisibilityMod.get()).doubleValue());
        }
    }

    @SubscribeEvent
    public void sleepTimeCheck(SleepingTimeCheckEvent event) {
        if (Helper.isVampire(event.getPlayer())) {
            event.getSleepingLocation().ifPresent(blockPos -> event.setResult(event.getPlayer().field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof CoffinBlock ? (event.getPlayer().field_70170_p.func_72935_r() ? Event.Result.ALLOW : Event.Result.DENY) : event.getResult()));
        }
        if (Helper.isHunter(event.getPlayer())) {
            event.getSleepingLocation().ifPresent(blockPos -> event.setResult(event.getPlayer().func_130014_f_().func_180495_p(blockPos).func_177230_c() instanceof TentBlock ? (!event.getPlayer().func_130014_f_().func_72935_r() ? Event.Result.ALLOW : Event.Result.DENY) : event.getResult()));
        }
    }

    private boolean checkItemUsePerm(ItemStack stack, PlayerEntity player) {
        boolean message;
        boolean bl = message = !player.func_130014_f_().field_72995_K;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IFactionLevelItem) {
            IFactionPlayer factionPlayer;
            if (!player.func_70089_S()) {
                return false;
            }
            IFactionLevelItem item = (IFactionLevelItem)stack.func_77973_b();
            FactionPlayerHandler handler = FactionPlayerHandler.get(player);
            IPlayableFaction usingFaction = item.getUsingFaction(stack);
            ISkill requiredSkill = item.getRequiredSkill(stack);
            if (usingFaction != null && !handler.isInFaction(usingFaction)) {
                if (message) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.can_only_be_used_by", new Object[]{usingFaction.getNamePlural()}));
                }
                return false;
            }
            if (handler.getCurrentLevel() < item.getMinLevel(stack)) {
                if (message) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.can_only_be_used_by_level", new Object[]{usingFaction == null ? new TranslationTextComponent("text.vampirism.all", new Object[0]) : usingFaction.getNamePlural(), item.getMinLevel(stack)}));
                }
                return false;
            }
            if (!(requiredSkill == null || (factionPlayer = (IFactionPlayer)handler.getCurrentFactionPlayer().orElse(null)) != null && factionPlayer.getSkillHandler().isSkillEnabled(requiredSkill))) {
                if (message) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.can_only_be_used_with_skill", new Object[]{new TranslationTextComponent(requiredSkill.getTranslationKey(), new Object[0])}));
                }
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent
    public void sleepTimeFinish(SleepFinishedTimeEvent event) {
        boolean sleepingInCoffin;
        if (event.getWorld().func_201672_e().func_72935_r() && (sleepingInCoffin = event.getWorld().func_217369_A().stream().anyMatch(player -> {
            Optional pos = player.func_213374_dv();
            return pos.isPresent() && event.getWorld().func_180495_p((BlockPos)pos.get()).func_177230_c() instanceof CoffinBlock;
        }))) {
            long dist = event.getWorld().func_201672_e().func_72820_D() % 24000L > 12000L ? 13000L : -11000L;
            event.setTimeAddition(event.getNewTime() + dist);
        }
    }

    @SubscribeEvent
    public void eyeHeight(EntityEvent.EyeHeight event) {
        if (event.getEntity() instanceof PlayerEntity && event.getEntity().func_70089_S() && event.getEntity().func_174791_d().func_189985_c() != 0.0 && ((Boolean)VampirePlayer.getOpt((PlayerEntity)event.getEntity()).map(vampire -> vampire.getSpecialAttributes().bat).orElse((Object)false)).booleanValue()) {
            event.setNewHeight(0.51000005f);
        }
    }
}

