/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.hunter.actions;

import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.DefaultHunterAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class AwarenessHunterAction
extends DefaultHunterAction
implements ILastingAction<IHunterPlayer> {
    @Override
    public boolean canBeUsedBy(IHunterPlayer player) {
        return !player.getActionHandler().isActionActive(HunterActions.disguise_hunter);
    }

    @Override
    public int getCooldown() {
        return (Integer)VampirismConfig.BALANCE.haAwarenessCooldown.get();
    }

    @Override
    public int getDuration(int level) {
        return (Integer)VampirismConfig.BALANCE.haAwarenessDuration.get();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.haAwarenessEnabled.get();
    }

    @Override
    public void onActivatedClient(IHunterPlayer player) {
        this.onUpdate(player);
    }

    @Override
    public void onDeactivated(IHunterPlayer player) {
        ((HunterPlayer)player).getSpecialAttributes().resetVampireNearby();
    }

    @Override
    public void onReActivated(IHunterPlayer player) {
        this.onUpdate(player);
    }

    @Override
    public boolean onUpdate(IHunterPlayer player) {
        if (player.getRepresentingEntity().field_70173_aa % 20 != 0) {
            if (((HunterPlayer)player).getSpecialAttributes().isVampireNearby()) {
                ((HunterPlayer)player).getSpecialAttributes().nearbyVampire();
            }
        } else if (this.nearbyVampire(player)) {
            ((HunterPlayer)player).getSpecialAttributes().nearbyVampire();
        } else {
            ((HunterPlayer)player).getSpecialAttributes().resetVampireNearby();
        }
        return false;
    }

    @Override
    protected boolean activate(IHunterPlayer player) {
        this.onUpdate(player);
        return true;
    }

    private boolean nearbyVampire(IHunterPlayer player) {
        int r = (Integer)VampirismConfig.BALANCE.haAwarenessRadius.get();
        List entities = player.getRepresentingEntity().func_130014_f_().func_217357_a(LivingEntity.class, new AxisAlignedBB(player.getRepresentingEntity().field_70165_t - (double)r, player.getRepresentingEntity().field_70163_u - (double)r + 1.0, player.getRepresentingEntity().field_70161_v - (double)r, player.getRepresentingEntity().field_70165_t + (double)r, player.getRepresentingEntity().field_70163_u + (double)r + 1.0, player.getRepresentingEntity().field_70161_v + (double)r));
        for (LivingEntity e : entities) {
            if (!Helper.isVampire((Entity)e)) continue;
            return true;
        }
        return false;
    }
}

