/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.player.skills.SkillManager;
import de.teamlapen.vampirism.player.skills.SkillNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkillTree {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, SkillNode> rootNodes = new HashMap<ResourceLocation, SkillNode>();
    private final Map<ResourceLocation, Integer[]> skillNodeSizeMap = new HashMap<ResourceLocation, Integer[]>();

    public Map<ResourceLocation, SkillNode.Builder> getCopy() {
        HashMap<ResourceLocation, SkillNode.Builder> map = new HashMap<ResourceLocation, SkillNode.Builder>();
        for (SkillNode root : this.rootNodes.values()) {
            this.addChildenCopyToMap(root, map);
        }
        return map;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Integer[] getDisplayInfo(ResourceLocation faction) {
        if (!this.skillNodeSizeMap.containsKey(faction)) {
            this.skillNodeSizeMap.put(faction, this.createDisplayInfo(this.getRootNodeForFaction(faction)));
        }
        return this.skillNodeSizeMap.get(faction);
    }

    public SkillNode getRootNodeForFaction(ResourceLocation id) {
        if (!this.rootNodes.containsKey(id)) {
            throw new IllegalStateException("Faction " + id + " does not have a root skill");
        }
        return this.rootNodes.get(id);
    }

    public void initRootSkills() {
        this.rootNodes.clear();
        for (IPlayableFaction faction : VampirismAPI.factionRegistry().getPlayableFactions()) {
            SkillNode rootNode = new SkillNode(faction, ((SkillManager)VampirismAPI.skillManager()).getRootSkill(faction));
            this.rootNodes.put(faction.getID(), rootNode);
        }
    }

    public void loadNodes(Map<ResourceLocation, SkillNode.Builder> nodes) {
        HashMap<ResourceLocation, SkillNode> builtNodes = new HashMap<ResourceLocation, SkillNode>();
        this.rootNodes.clear();
        for (IPlayableFaction faction : VampirismAPI.factionRegistry().getPlayableFactions()) {
            SkillNode rootNode = new SkillNode(faction, ((SkillManager)VampirismAPI.skillManager()).getRootSkill(faction));
            builtNodes.put(faction.getID(), rootNode);
            this.rootNodes.put(faction.getID(), rootNode);
        }
        Iterator<Map.Entry<ResourceLocation, SkillNode.Builder>> it = nodes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ResourceLocation, SkillNode.Builder> entry = it.next();
            SkillNode.Builder builder = entry.getValue();
            if (builder.mergeId == null) continue;
            SkillNode.Builder b = nodes.get(builder.mergeId);
            if (b == null) {
                LOGGER.error("Could not load skill node {} because merge target {} couldn't be found", (Object)entry.getKey(), (Object)builder.mergeId);
            } else {
                b.skills.addAll(builder.skills);
            }
            it.remove();
        }
        while (!nodes.isEmpty()) {
            boolean flag = false;
            Iterator<Map.Entry<ResourceLocation, SkillNode.Builder>> iterator = nodes.entrySet().iterator();
            while (iterator.hasNext()) {
                SkillNode parent;
                Map.Entry<ResourceLocation, SkillNode.Builder> entry = iterator.next();
                ResourceLocation id = entry.getKey();
                SkillNode.Builder builder = entry.getValue();
                if (builder.parentId == null || (parent = (SkillNode)builtNodes.get(builder.parentId)) == null) continue;
                if (!builder.checkSkillFaction(parent.getFaction())) {
                    LOGGER.error("Cannot create skill node {} because skills do not match the derived faction {}", (Object)id, (Object)parent.getFaction());
                } else {
                    builtNodes.put(id, new SkillNode(id, parent, builder.skills.toArray(new ISkill[0])));
                }
                iterator.remove();
                flag = true;
            }
            if (flag) continue;
            for (Map.Entry<ResourceLocation, SkillNode.Builder> entry : nodes.entrySet()) {
                LOGGER.error("Could not load skill node (probably parent invalid) {}: {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        LOGGER.info("Loaded {} skill nodes", (Object)(builtNodes.size() - this.rootNodes.size()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateRenderInfo() {
        for (SkillNode n : this.rootNodes.values()) {
            this.setRenderPos(n, 0);
        }
    }

    private void addChildenCopyToMap(SkillNode n, Map<ResourceLocation, SkillNode.Builder> map) {
        for (SkillNode c : n.getChildren()) {
            map.put(c.getId(), c.getCopy());
            this.addChildenCopyToMap(c, map);
        }
    }

    private int calculateEndPoints(SkillNode start) {
        if (start.getChildren().size() == 0) {
            return 1;
        }
        int count = 0;
        for (SkillNode node : start.getChildren()) {
            count += this.calculateEndPoints(node);
        }
        return count;
    }

    private int calculateMaxSkillDepth(SkillNode start) {
        int max = start.getDepth();
        for (SkillNode node : start.getChildren()) {
            int n = this.calculateMaxSkillDepth(node);
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    private int calculateMaxSkillsPerNode(SkillNode start) {
        int max = start.getElements().length;
        for (SkillNode node : start.getChildren()) {
            int n = this.calculateMaxSkillsPerNode(node);
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    private Integer[] createDisplayInfo(SkillNode root) {
        Integer[] info = new Integer[]{this.calculateEndPoints(root), this.calculateMaxSkillsPerNode(root), this.calculateMaxSkillDepth(root) + 1};
        return info;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setRenderPos(SkillNode base, int column) {
        int i;
        int left = -(base.getElements().length * 2 - 1) / 2;
        for (ISkill skill : base.getElements()) {
            skill.setRenderPos(base.getDepth() * 2, column + left);
            left += 2;
        }
        int[] widths = new int[base.getChildren().size()];
        int total = 0;
        for (i = 0; i < widths.length; ++i) {
            SkillNode node = base.getChildren().get(i);
            widths[i] = this.calculateMaxSkillsPerNode(node) * this.calculateEndPoints(node) * 2;
            total += widths[i];
        }
        left = -total / 2;
        for (i = 0; i < widths.length; ++i) {
            this.setRenderPos(base.getChildren().get(i), column + left + widths[i] / 2);
            left += widths[i];
        }
    }
}

