/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.vampire.IBloodStats;
import de.teamlapen.vampirism.config.VampirismConfig;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BloodStats
implements IBloodStats {
    private static final Logger LOGGER = LogManager.getLogger(BloodStats.class);
    private final PlayerEntity player;
    private int maxBlood = 20;
    private int bloodLevel = 20;
    private float bloodSaturationLevel = 5.0f;
    private float bloodExhaustionLevel;
    private int bloodTimer;
    private int prevBloodLevel = 20;
    private boolean changed = false;

    BloodStats(PlayerEntity player) {
        this.player = player;
    }

    @Override
    public int getBloodLevel() {
        return this.bloodLevel;
    }

    void setBloodLevel(int amt) {
        this.bloodLevel = amt < 0 ? 0 : (amt > this.maxBlood ? this.maxBlood : amt);
        this.changed = true;
    }

    @Override
    public int getMaxBlood() {
        return this.maxBlood;
    }

    void setMaxBlood(int maxBlood) {
        this.maxBlood = Math.max(1, maxBlood);
        if (this.bloodLevel > maxBlood) {
            this.bloodLevel = maxBlood;
        }
        this.changed = true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getPrevBloodLevel() {
        return this.prevBloodLevel;
    }

    @Override
    public boolean needsBlood() {
        return this.bloodLevel < this.maxBlood;
    }

    public boolean onUpdate() {
        boolean regen;
        FoodStats foodStats = this.player.func_71024_bL();
        foodStats.func_75114_a(10);
        Difficulty enumDifficulty = this.player.func_130014_f_().func_175659_aa();
        float exhaustion = foodStats.field_75126_c;
        foodStats.field_75126_c = 0.0f;
        this.addExhaustion(exhaustion);
        this.prevBloodLevel = this.bloodLevel;
        if (this.bloodExhaustionLevel > 4.0f) {
            this.bloodExhaustionLevel -= 4.0f;
            if (this.bloodSaturationLevel > 0.0f) {
                this.bloodSaturationLevel = Math.max(this.bloodSaturationLevel - 1.0f, 0.0f);
            } else if (enumDifficulty != Difficulty.PEACEFUL || ((Boolean)VampirismConfig.BALANCE.vpBloodUsagePeaceful.get()).booleanValue()) {
                this.bloodLevel = Math.max(this.bloodLevel - 1, 0);
            }
        }
        if ((regen = this.player.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223606_i)) && this.bloodSaturationLevel > 0.0f && this.player.func_70996_bM() && this.bloodLevel >= this.maxBlood) {
            ++this.bloodTimer;
            if (this.bloodTimer >= 10) {
                float f = Math.min(this.bloodSaturationLevel, 4.0f);
                this.player.func_70691_i(f / 4.0f);
                this.addExhaustion(f, true);
                this.bloodTimer = 0;
            }
        } else if (regen && this.bloodLevel >= 18 && this.player.func_70996_bM()) {
            ++this.bloodTimer;
            if (this.bloodTimer >= 80) {
                this.player.func_70691_i(1.0f);
                this.addExhaustion(2.8f, true);
                this.bloodTimer = 0;
            }
        } else if (this.bloodLevel <= 0) {
            ++this.bloodTimer;
            if (this.bloodTimer >= 80) {
                if (this.player.func_110143_aJ() > 10.0f || enumDifficulty == Difficulty.HARD || this.player.func_110143_aJ() > 1.0f && enumDifficulty == Difficulty.NORMAL) {
                    this.player.func_70097_a(DamageSource.field_76366_f, 1.5f);
                }
                this.bloodTimer = 0;
            }
        } else {
            this.bloodTimer = 0;
        }
        if (this.changed || this.prevBloodLevel != this.bloodLevel) {
            this.changed = false;
            return true;
        }
        return false;
    }

    public void readNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("bloodLevel")) {
            this.bloodLevel = nbt.func_74762_e("bloodLevel");
            if (nbt.func_74764_b("bloodTimer")) {
                this.bloodTimer = nbt.func_74762_e("bloodTimer");
                this.bloodSaturationLevel = nbt.func_74760_g("bloodSaturation");
                this.bloodExhaustionLevel = nbt.func_74760_g("bloodExhaustion");
            }
            if (nbt.func_74764_b("maxBlood")) {
                this.maxBlood = nbt.func_74762_e("maxBlood");
            }
        }
    }

    int addBlood(int amount, float saturationModifier) {
        int add = Math.min(amount, this.maxBlood - this.bloodLevel);
        this.bloodLevel += add;
        this.bloodSaturationLevel = Math.min(this.bloodSaturationLevel + (float)add * saturationModifier * 2.0f, (float)this.bloodLevel);
        this.changed = true;
        return amount - add;
    }

    void addExhaustion(float amount) {
        this.addExhaustion(amount, false);
    }

    void addExhaustion(float amount, boolean ignoreModifier) {
        IAttributeInstance attribute = this.player.func_110148_a(VReference.bloodExhaustion);
        float mult = ignoreModifier ? 1.0f : (float)attribute.func_111126_e();
        this.bloodExhaustionLevel = Math.min(this.bloodExhaustionLevel + amount * mult, 40.0f);
    }

    void loadUpdate(CompoundNBT nbt) {
        if (nbt.func_74764_b("maxBlood")) {
            this.setMaxBlood(nbt.func_74762_e("maxBlood"));
        }
        if (nbt.func_74764_b("bloodLevel")) {
            this.setBloodLevel(nbt.func_74762_e("bloodLevel"));
        }
    }

    boolean removeBlood(int a, boolean allowPartial) {
        if (this.bloodLevel >= a) {
            this.bloodLevel -= a;
            this.changed = true;
            return true;
        }
        if (allowPartial) {
            this.bloodLevel = 0;
            this.changed = true;
        }
        return false;
    }

    void writeNBT(CompoundNBT nbt) {
        this.writeNBTBlood(nbt);
        nbt.func_74768_a("bloodTimer", this.bloodTimer);
        nbt.func_74776_a("bloodSaturation", this.bloodSaturationLevel);
        nbt.func_74776_a("bloodExhaustion", this.bloodExhaustionLevel);
        nbt.func_74768_a("maxBlood", this.maxBlood);
    }

    void writeNBTBlood(CompoundNBT nbt) {
        nbt.func_74768_a("bloodLevel", this.bloodLevel);
    }

    CompoundNBT writeUpdate(CompoundNBT nbt) {
        nbt.func_74768_a("bloodLevel", this.bloodLevel);
        nbt.func_74768_a("maxBlood", this.maxBlood);
        return nbt;
    }
}

