/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire.actions;

import de.teamlapen.vampirism.advancements.VampireActionTrigger;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import java.util.UUID;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.EndDimension;

public class BatVampireAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    public static final float BAT_EYE_HEIGHT = 0.51000005f;
    public static final EntitySize BAT_SIZE = EntitySize.func_220311_c((float)0.8f, (float)0.6f);
    public final UUID healthModifierUUID = UUID.fromString("4392fccb-4bfd-4290-b2e6-5cc91429053c");
    private final float PLAYER_WIDTH = 0.6f;
    private final float PLAYER_HEIGHT = 1.8f;

    @Override
    public boolean activate(IVampirePlayer vampire) {
        PlayerEntity player = vampire.getRepresentingPlayer();
        float oldMax = player.func_110138_aP();
        float oldHealth = player.func_110143_aJ();
        this.setModifier(player, true);
        float newMax = player.func_110138_aP();
        float mult = newMax / oldMax;
        float newHealth = mult * oldHealth;
        if (newHealth < 1.0f) {
            newHealth = 1.0f;
        }
        player.func_70606_j(newHealth);
        this.updatePlayer((VampirePlayer)vampire, true);
        if (player instanceof ServerPlayerEntity) {
            ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayerEntity)player, VampireActionTrigger.Action.BAT);
        }
        return true;
    }

    @Override
    public boolean canBeUsedBy(IVampirePlayer vampire) {
        return !vampire.isGettingSundamage((IWorld)vampire.getRepresentingEntity().field_70170_p) && !((Object)((Object)ModItems.umbrella)).equals(vampire.getRepresentingEntity().func_184614_ca().func_77973_b()) && vampire.isGettingGarlicDamage((IWorld)vampire.getRepresentingEntity().field_70170_p) == EnumStrength.NONE && !vampire.getActionHandler().isActionActive(VampireActions.vampire_rage) && !vampire.getRepresentingPlayer().func_70090_H() && ((Boolean)VampirismConfig.SERVER.batModeInEnd.get() != false || !(vampire.getRepresentingPlayer().func_130014_f_().field_73011_w instanceof EndDimension));
    }

    @Override
    public int getCooldown() {
        return (Integer)VampirismConfig.BALANCE.vaBatCooldown.get() * 20 + 1;
    }

    @Override
    public int getDuration(int level) {
        return MathHelper.func_76125_a((int)((Integer)VampirismConfig.BALANCE.vaBatDuration.get()), (int)10, (int)0x6666665) * 20;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaBatEnabled.get();
    }

    @Override
    public void onActivatedClient(IVampirePlayer vampire) {
        if (!((VampirePlayer)vampire).getSpecialAttributes().bat) {
            this.updatePlayer((VampirePlayer)vampire, true);
        }
    }

    @Override
    public void onDeactivated(IVampirePlayer vampire) {
        PlayerEntity player = vampire.getRepresentingPlayer();
        float oldMax = player.func_110138_aP();
        float oldHealth = player.func_110143_aJ();
        this.setModifier(player, false);
        float newMax = player.func_110138_aP();
        float mult = newMax / oldMax;
        float newHealth = mult * oldHealth;
        player.func_70606_j(newHealth);
        if (!player.field_70122_E) {
            player.func_195064_c(new EffectInstance(Effects.field_76429_m, 20, 100, false, false));
        }
        this.updatePlayer((VampirePlayer)vampire, false);
    }

    @Override
    public void onReActivated(IVampirePlayer vampire) {
        this.setModifier(vampire.getRepresentingPlayer(), true);
        if (!((VampirePlayer)vampire).getSpecialAttributes().bat) {
            this.updatePlayer((VampirePlayer)vampire, true);
        }
    }

    @Override
    public boolean onUpdate(IVampirePlayer vampire) {
        if (vampire.isGettingSundamage((IWorld)vampire.getRepresentingEntity().field_70170_p) && !vampire.isRemote()) {
            vampire.getRepresentingPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_day", new Object[0]));
            return true;
        }
        if (((Object)((Object)ModItems.umbrella)).equals(vampire.getRepresentingEntity().func_184614_ca().func_77973_b()) && !vampire.isRemote()) {
            vampire.getRepresentingPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_umbrella", new Object[0]));
            return true;
        }
        if (vampire.isGettingGarlicDamage((IWorld)vampire.getRepresentingEntity().field_70170_p) != EnumStrength.NONE && !vampire.isRemote()) {
            vampire.getRepresentingEntity().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_garlic", new Object[0]));
            return true;
        }
        if (!((Boolean)VampirismConfig.SERVER.batModeInEnd.get()).booleanValue() && vampire.getRepresentingPlayer().func_130014_f_().field_73011_w instanceof EndDimension) {
            vampire.getRepresentingPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_end", new Object[0]));
            return true;
        }
        return vampire.getRepresentingPlayer().func_70090_H();
    }

    private void setFlightSpeed(PlayerEntity player, float speed) {
        player.field_71075_bZ.field_75096_f = speed;
    }

    private void setModifier(PlayerEntity player, boolean enabled) {
        if (enabled) {
            IAttributeInstance health = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (health.func_111127_a(this.healthModifierUUID) == null) {
                health.func_111121_a(new AttributeModifier(this.healthModifierUUID, "Bat Health Reduction", -((Double)VampirismConfig.BALANCE.vaBatHealthReduction.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL).func_111168_a(false));
            }
            player.field_71075_bZ.field_75101_c = true;
            player.field_71075_bZ.field_75100_b = true;
            this.setFlightSpeed(player, 0.03f);
            player.func_71016_p();
        } else {
            IAttributeInstance health = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            AttributeModifier m = health.func_111127_a(this.healthModifierUUID);
            if (m != null) {
                health.func_111124_b(m);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = false;
            }
            player.field_71075_bZ.field_75100_b = false;
            this.setFlightSpeed(player, 0.05f);
            player.func_71016_p();
        }
    }

    private void updatePlayer(VampirePlayer vampire, boolean bat) {
        PlayerEntity player = vampire.getRepresentingPlayer();
        vampire.getSpecialAttributes().bat = bat;
        player.func_213323_x_();
        if (bat) {
            player.func_70107_b(player.field_70165_t, player.field_70163_u + (double)(1.8f - BatVampireAction.BAT_SIZE.field_220316_b), player.field_70161_v);
        }
    }
}

