/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.potion.blood;

import de.teamlapen.vampirism.api.items.IBloodPotionEffect;
import de.teamlapen.vampirism.api.items.IBloodPotionPropertyRandomizer;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

class BloodPotionEffect
implements IBloodPotionEffect {
    private final ResourceLocation id;
    private final Effect potion;
    private final boolean isBad;
    private final int weight;
    private final IBloodPotionPropertyRandomizer propertyRandomizer;

    BloodPotionEffect(ResourceLocation id, Effect potion, boolean isBad, int weight, IBloodPotionPropertyRandomizer propertyRandomizer) {
        this.id = id;
        this.potion = potion;
        this.isBad = isBad;
        this.propertyRandomizer = propertyRandomizer;
        this.weight = weight;
    }

    @Override
    public boolean canCoexist(@Nonnull IBloodPotionEffect other) {
        if (this.isBad() != other.isBad()) {
            return true;
        }
        if (other instanceof BloodPotionEffect) {
            return !this.potion.equals(((BloodPotionEffect)other).potion);
        }
        return true;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public ITextComponent getLocName(CompoundNBT properties) {
        return this.potion.func_199286_c();
    }

    @Override
    public CompoundNBT getRandomProperties(Random rng) {
        return this.propertyRandomizer.getRandomProperties(rng);
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public boolean isBad() {
        return this.isBad;
    }

    @Override
    public void onActivated(LivingEntity hunter, CompoundNBT nbt, float durationMult) {
        hunter.func_195064_c(new EffectInstance(this.potion, (int)((float)nbt.func_74762_e("duration") * durationMult), nbt.func_74762_e("amplifier")));
    }

    public String toString() {
        return "BloodPotionEffect{potion=" + this.potion + ", isBad=" + this.isBad + '}';
    }
}

