/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.potion.blood;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.items.IBloodPotionCategory;
import de.teamlapen.vampirism.api.items.IBloodPotionEffect;
import de.teamlapen.vampirism.api.items.IBloodPotionPropertyRandomizer;
import de.teamlapen.vampirism.api.items.IBloodPotionRegistry;
import de.teamlapen.vampirism.potion.blood.BloodPotionCategory;
import de.teamlapen.vampirism.potion.blood.BloodPotionEffect;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import org.apache.commons.lang3.tuple.Triple;

public class BloodPotionRegistry
implements IBloodPotionRegistry {
    private final List<BloodPotionCategory> categoriesGood = Lists.newArrayList();
    private final List<BloodPotionCategory> categoriesBad = Lists.newArrayList();
    private final Map<ResourceLocation, IBloodPotionEffect> allEffects = Maps.newHashMap();
    private final Queue<Triple<ResourceLocation, Boolean, Object[]>> categoryItemsQueue = new ConcurrentLinkedQueue<Triple<ResourceLocation, Boolean, Object[]>>();
    private final Queue<Triple<ResourceLocation, Boolean, BloodPotionEffect>> potionsEffectsQueue = new ConcurrentLinkedQueue<Triple<ResourceLocation, Boolean, BloodPotionEffect>>();

    @Override
    public void addItemsToCategory(boolean bad, @Nonnull ResourceLocation categoryId, Item ... items) {
        this.categoryItemsQueue.add((Triple<ResourceLocation, Boolean, Object[]>)Triple.of((Object)categoryId, (Object)bad, (Object)items));
    }

    public void finish() {
        IBloodPotionCategory cat;
        for (Triple triple : this.categoryItemsQueue) {
            cat = this.getOrCreateCategory((ResourceLocation)triple.getLeft(), (Boolean)triple.getMiddle());
            cat.addItems((Object[])triple.getRight());
        }
        for (Triple triple : this.potionsEffectsQueue) {
            cat = this.getOrCreateCategory((ResourceLocation)triple.getLeft(), (Boolean)triple.getMiddle());
            BloodPotionEffect effect = (BloodPotionEffect)triple.getRight();
            if (this.allEffects.containsKey(effect.getId())) {
                throw new IllegalArgumentException("Blood Potion Effect with id " + effect.getId() + " is already registered: " + this.allEffects.get(effect.getId()));
            }
            this.allEffects.put(effect.getId(), effect);
            ((BloodPotionCategory)cat).addEffect(effect, effect.getWeight());
        }
        this.categoryItemsQueue.clear();
        this.potionsEffectsQueue.clear();
    }

    @Override
    @Nullable
    public IBloodPotionEffect getEffectFromId(@Nonnull ResourceLocation id) {
        return this.allEffects.get(id);
    }

    @Override
    @Nonnull
    public List<String> getLocCategoryDescForItem(@Nonnull ItemStack item) {
        assert (!item.func_190926_b());
        LinkedList categories = Lists.newLinkedList();
        categories.addAll(this.categoriesBad);
        categories.addAll(this.categoriesGood);
        ArrayList desc = Lists.newArrayList();
        for (IBloodPotionCategory category : categories) {
            if (!category.containsItem(item)) continue;
            desc.add(UtilLib.translate(category.getDescTranslationKey(), new Object[0]));
        }
        return desc;
    }

    @Override
    @Nonnull
    public IBloodPotionEffect getRandomEffect(@Nonnull ItemStack item, boolean bad, Random rnd) {
        ArrayList effects = Lists.newArrayList();
        List<BloodPotionCategory> categories = bad ? this.categoriesBad : this.categoriesGood;
        for (BloodPotionCategory category : categories) {
            if (!item.func_190926_b() && category.containsItem(item)) {
                for (IBloodPotionRegistry.WeightedEffect effect : category.getImmutableEffectsList()) {
                    effects.add(new IBloodPotionRegistry.WeightedEffect(effect.effect, effect.field_76292_a * 5));
                }
                continue;
            }
            effects.addAll(category.getImmutableEffectsList());
        }
        return ((IBloodPotionRegistry.WeightedEffect)WeightedRandom.func_76271_a((Random)rnd, (List)effects)).effect;
    }

    @Override
    public void registerPotionEffect(ResourceLocation id, ResourceLocation categoryId, boolean isBad, Effect potion, int weight, IBloodPotionPropertyRandomizer propertyRandomizer) {
        BloodPotionEffect effect = new BloodPotionEffect(id, potion, isBad, weight, propertyRandomizer);
        this.potionsEffectsQueue.add((Triple<ResourceLocation, Boolean, BloodPotionEffect>)Triple.of((Object)categoryId, (Object)isBad, (Object)effect));
    }

    private IBloodPotionCategory getOrCreateCategory(@Nonnull ResourceLocation id, boolean isBad) {
        List<BloodPotionCategory> categories = isBad ? this.categoriesBad : this.categoriesGood;
        for (BloodPotionCategory category : categories) {
            if (!category.getId().equals((Object)id)) continue;
            return category;
        }
        BloodPotionCategory category = new BloodPotionCategory(id);
        categories.add(category);
        return category;
    }
}

