/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.blocks.AlchemicalCauldronBlock;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.inventory.container.AlchemicalCauldronContainer;
import de.teamlapen.vampirism.inventory.recipes.AlchemicalCauldronRecipe;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class AlchemicalCauldronTileEntity
extends AbstractFurnaceTileEntity {
    private static final int[] SLOTS_DOWN = new int[]{0, 1, 2};
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_WEST = new int[]{1};
    private static final int[] SLOTS_FUEL = new int[]{3};
    @Nullable
    private UUID ownerID;
    @Nullable
    private String ownerName;
    private AlchemicalCauldronRecipe recipeChecked;

    public AlchemicalCauldronTileEntity() {
        super(ModTiles.alchemical_cauldron, ModRecipes.ALCHEMICAL_CAULDRON_TYPE);
        this.field_214012_a = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    }

    public boolean func_213904_e(PlayerEntity player) {
        if (super.func_213904_e(player)) {
            if (((Boolean)HunterPlayer.getOpt(player).map(HunterPlayer::getSkillHandler).map(h -> h.isSkillEnabled(HunterSkills.basic_alchemy)).orElse((Object)false)).booleanValue()) {
                if (this.ownerID == null) {
                    this.setOwnerID(player);
                    return true;
                }
                if (this.ownerID.equals(player.func_110124_au())) {
                    return true;
                }
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.alchemical_cauldron.other", new Object[]{this.getOwnerName()}));
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.alchemical_cauldron.cannot_use", new Object[]{this.getOwnerName()}));
            }
        }
        return false;
    }

    @Nonnull
    public ITextComponent func_200201_e() {
        return new TranslationTextComponent("tile.vampirism.alchemical_cauldron.name", new Object[0]);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("tile.vampirism.alchemical_cauldron.display", new Object[]{this.ownerName, new TranslationTextComponent("tile.vampirism.alchemical_cauldron.name", new Object[0])});
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getLiquidColorClient() {
        ItemStack liquidItem = (ItemStack)this.field_214012_a.get(0);
        return (Integer)FluidUtil.getFluidContained((ItemStack)liquidItem).map(fluidStack -> fluidStack.getFluid().getAttributes().getColor()).orElse((Object)ModRecipes.getLiquidColor(liquidItem.func_77973_b()));
    }

    public ITextComponent getOwnerName() {
        return new StringTextComponent(this.ownerName == null ? "Unknown" : this.ownerName);
    }

    @Nonnull
    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : (side == Direction.WEST ? SLOTS_WEST : SLOTS_FUEL);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = super.func_189517_E_();
        if (this.ownerID != null) {
            compound.func_186854_a("owner", this.ownerID);
        }
        if (this.ownerName != null) {
            compound.func_74778_a("owner_name", this.ownerName);
        }
        ItemStackHelper.func_191282_a((CompoundNBT)compound, (NonNullList)this.field_214012_a);
        return compound;
    }

    public void handleUpdateTag(CompoundNBT compound) {
        super.handleUpdateTag(compound);
        this.ownerID = compound.func_186855_b("owner") ? compound.func_186857_a("owner") : null;
        this.ownerName = compound.func_74764_b("owner_name") ? compound.func_74779_i("owner_name") : null;
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)this.field_214012_a);
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            super.func_70296_d();
            BlockState old = this.field_145850_b.func_180495_p(this.field_174879_c);
            BlockState state = (BlockState)((BlockState)old.func_206870_a((IProperty)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(this.isBurning()))).func_206870_a((IProperty)AlchemicalCauldronBlock.LIQUID, (Comparable)Integer.valueOf(((ItemStack)this.field_214012_a.get(0)).func_190926_b() ? 0 : (this.isBurning() ? 2 : 1)));
            if (old.equals((Object)state)) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
            } else {
                this.field_145850_b.func_180501_a(this.field_174879_c, state, 3);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.handleUpdateTag(nbt);
    }

    public void func_145839_a(CompoundNBT compound) {
        this.ownerID = compound.func_186855_b("owner") ? compound.func_186857_a("owner") : null;
        this.ownerName = compound.func_74764_b("owner_name") ? compound.func_74779_i("owner_name") : null;
        super.func_145839_a(compound);
    }

    public void setOwnerID(PlayerEntity player) {
        this.ownerID = player.func_110124_au();
        this.ownerName = player.func_145748_c_().func_150254_d();
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        boolean wasBurning = this.isBurning();
        boolean dirty = false;
        if (wasBurning) {
            this.field_214013_b.func_221477_a(0, this.field_214013_b.func_221476_a(0) - 1);
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstackFuel = (ItemStack)this.field_214012_a.get(3);
            if (this.isBurning() || !itemstackFuel.func_190926_b() && !((ItemStack)this.field_214012_a.get(0)).func_190926_b() && !((ItemStack)this.field_214012_a.get(1)).func_190926_b()) {
                AlchemicalCauldronRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(this.field_214014_c, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isBurning() && this.func_214008_b((IRecipe)irecipe) && this.canPlayerCook(irecipe)) {
                    this.field_214013_b.func_221477_a(0, this.func_213997_a(itemstackFuel));
                    this.field_214013_b.func_221477_a(1, this.field_214013_b.func_221476_a(0));
                    if (this.isBurning()) {
                        dirty = true;
                        if (itemstackFuel.hasContainerItem()) {
                            this.field_214012_a.set(3, (Object)itemstackFuel.getContainerItem());
                        } else if (!itemstackFuel.func_190926_b()) {
                            Item item = itemstackFuel.func_77973_b();
                            itemstackFuel.func_190918_g(1);
                            if (itemstackFuel.func_190926_b()) {
                                this.field_214012_a.set(3, (Object)itemstackFuel.getContainerItem());
                            }
                        }
                    }
                }
                if (this.isBurning() && this.func_214008_b((IRecipe)irecipe) && this.canPlayerCook(irecipe)) {
                    this.field_214013_b.func_221477_a(2, this.field_214013_b.func_221476_a(2) + 1);
                    if (this.field_214013_b.func_221476_a(2) == this.field_214013_b.func_221476_a(3)) {
                        this.field_214013_b.func_221477_a(2, 0);
                        this.field_214013_b.func_221477_a(3, this.func_214005_h());
                        this.finishCooking(irecipe);
                        dirty = true;
                    }
                } else {
                    this.field_214013_b.func_221477_a(2, 0);
                }
            } else if (!this.isBurning() && this.field_214013_b.func_221476_a(2) > 0) {
                this.field_214013_b.func_221477_a(2, MathHelper.func_76125_a((int)(this.field_214013_b.func_221476_a(2) - 2), (int)0, (int)this.field_214013_b.func_221476_a(3)));
            }
            if (wasBurning != this.isBurning()) {
                dirty = true;
            }
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean flag;
        super.func_70299_a(index, stack);
        ItemStack itemstack = (ItemStack)this.field_214012_a.get(index);
        boolean bl = flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        if (flag) {
            this.func_70296_d();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.ownerID != null) {
            compound.func_186854_a("owner", this.ownerID);
        }
        if (this.ownerName != null) {
            compound.func_74778_a("owner_name", this.ownerName);
        }
        return super.func_189515_b(compound);
    }

    @Nonnull
    protected Container func_213906_a(int id, PlayerInventory player) {
        return new AlchemicalCauldronContainer(id, player, (IInventory)this, this.field_214013_b, this.field_145850_b == null ? IWorldPosCallable.field_221489_a : IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c));
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("tile.vampirism.alchemical_cauldron", new Object[0]);
    }

    private boolean canPlayerCook(AlchemicalCauldronRecipe recipe) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.recipeChecked == recipe) {
            return true;
        }
        PlayerEntity playerEntity = this.field_145850_b.func_217371_b(this.ownerID);
        if (playerEntity == null || !playerEntity.func_70089_S()) {
            return false;
        }
        HunterPlayer hunter = HunterPlayer.get(playerEntity);
        boolean canCook = recipe.canBeCooked(hunter.getLevel(), hunter.getSkillHandler());
        if (canCook) {
            this.recipeChecked = recipe;
            return true;
        }
        this.recipeChecked = null;
        return false;
    }

    private void finishCooking(AlchemicalCauldronRecipe recipe) {
        if (recipe != null && this.func_214008_b((IRecipe)recipe) && this.canPlayerCook(recipe)) {
            ItemStack itemstackfluid = (ItemStack)this.field_214012_a.get(0);
            ItemStack itemstackingredient = (ItemStack)this.field_214012_a.get(1);
            ItemStack itemstack1result = recipe.func_77571_b();
            ItemStack itemstackoutput = (ItemStack)this.field_214012_a.get(2);
            if (itemstackoutput.func_190926_b()) {
                this.field_214012_a.set(2, (Object)itemstack1result.func_77946_l());
            } else if (itemstackoutput.func_77973_b() == itemstack1result.func_77973_b()) {
                itemstackoutput.func_190917_f(itemstack1result.func_190916_E());
            }
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.func_193056_a((IRecipe)recipe);
            }
            Either<Ingredient, FluidStack> fluid = recipe.getFluid();
            fluid.ifLeft(ingredient -> itemstackfluid.func_190918_g(1));
            fluid.ifRight(fluidStack -> this.field_214012_a.set(0, FluidUtil.getFluidHandler((ItemStack)itemstackfluid).map(handler -> {
                FluidStack drained = handler.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                if (drained.getAmount() < fluidStack.getAmount()) {
                    handler.drain(new FluidStack(fluidStack.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                }
                return handler.getContainer();
            }).orElse((Object)ItemStack.field_190927_a)));
            itemstackingredient.func_190918_g(1);
            this.recipeChecked = null;
        }
    }

    private boolean isBurning() {
        return this.field_214013_b.func_221476_a(0) > 0;
    }

    private boolean isCooking() {
        return this.field_214013_b.func_221476_a(2) > 0;
    }
}

