/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.special.DraculaHalloweenEntity;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HalloweenSpecial {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean enabled = false;
    private static int render_overlay;
    private List<UUID> blacklist = new ArrayList<UUID>();
    private int tickTimer = 0;

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean shouldEnable() {
        if (((Boolean)VampirismConfig.SERVER.disableHalloweenSpecial.get()).booleanValue()) {
            return false;
        }
        int day = Calendar.getInstance().get(5);
        int month = Calendar.getInstance().get(2);
        return false;
    }

    public static void checkEnable() {
        enabled = HalloweenSpecial.shouldEnable();
        if (enabled) {
            LOGGER.info("It's Halloween");
        }
    }

    public static boolean shouldRenderOverlay() {
        return render_overlay > 0;
    }

    public static void triggerOverlay(PlayerEntity target) {
        render_overlay = 150;
        ModParticles.spawnParticleClient(target.func_130014_f_(), (IParticleData)ModParticles.halloween, target.field_70165_t, target.field_70163_u, target.field_70161_v);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        int time;
        if (!enabled) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (render_overlay > 0) {
            --render_overlay;
        } else if (Minecraft.func_71410_x().field_71441_e != null && (time = (int)Minecraft.func_71410_x().field_71441_e.func_72820_D()) > 13000 && time < 13100) {
            HalloweenSpecial.triggerOverlay((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (!enabled) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (enabled) {
            ++this.tickTimer;
            if (this.tickTimer % 200 == 99) {
                for (ServerPlayerEntity p : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                    UUID u = p.func_110124_au();
                    if (this.blacklist.contains(u)) continue;
                    DraculaHalloweenEntity draculaHalloween = (DraculaHalloweenEntity)ModEntities.special_dracula_halloween.func_200721_a(p.func_130014_f_());
                    draculaHalloween.setOwnerId(u);
                    draculaHalloween.makeHide(200 + p.func_70681_au().nextInt(1000));
                    p.func_130014_f_().func_217376_c((Entity)draculaHalloween);
                    this.blacklist.add(u);
                }
                this.tickTimer = 0;
            }
        }
    }

    @SubscribeEvent
    public void onSleepInBed(PlayerSleepInBedEvent event) {
        if (enabled) {
            event.setResult(PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
            event.getEntityPlayer().func_146105_b((ITextComponent)new StringTextComponent("You cannot sleep on Halloween!"), false);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.blacklist.clear();
    }
}

